/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.util.concurrent.NotifyingFutureImpl;

public class AggregatingNotifyingFutureImpl<T>
extends NotifyingFutureImpl<T> {
    final List<Future<T>> futures;
    final AtomicInteger awaitingCompletions = new AtomicInteger();

    public AggregatingNotifyingFutureImpl(T actualReturnValue, int maxFutures) {
        super(actualReturnValue);
        this.futures = new ArrayList<Future<T>>(maxFutures);
        this.awaitingCompletions.set(maxFutures);
    }

    @Override
    public void setNetworkFuture(Future<T> future) {
        this.futures.add(future);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean aggregateValue = false;
        for (Future<T> f : this.futures) {
            aggregateValue = f.cancel(mayInterruptIfRunning) && aggregateValue;
        }
        return aggregateValue;
    }

    @Override
    public boolean isCancelled() {
        for (Future<T> f : this.futures) {
            if (!f.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        for (Future<T> f : this.futures) {
            if (f.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        for (Future<T> f : this.futures) {
            f.get();
        }
        return (T)this.actualReturnValue;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        for (Future<T> f : this.futures) {
            f.get(timeout, unit);
        }
        return (T)this.actualReturnValue;
    }

    @Override
    public void notifyDone() {
        if (this.awaitingCompletions.decrementAndGet() == 0) {
            super.notifyDone();
        }
    }
}

