/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;

public abstract class BaseNotifyingFuture<T>
implements NotifyingFuture<T> {
    final Set<FutureListener<T>> listeners = new CopyOnWriteArraySet<FutureListener<T>>();
    volatile boolean callCompleted = false;
    final ReadWriteLock listenerLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final NotifyingFuture<T> attachListener(FutureListener<T> objectFutureListener) {
        this.listenerLock.readLock().lock();
        try {
            if (!this.callCompleted) {
                this.listeners.add(objectFutureListener);
            }
            if (this.callCompleted) {
                objectFutureListener.futureDone(this);
            }
            BaseNotifyingFuture baseNotifyingFuture = this;
            return baseNotifyingFuture;
        }
        finally {
            this.listenerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDone() {
        this.listenerLock.writeLock().lock();
        try {
            this.callCompleted = true;
            for (FutureListener<T> l : this.listeners) {
                l.futureDone(this);
            }
        }
        finally {
            this.listenerLock.writeLock().unlock();
        }
    }
}

