/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser52;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.loaders.remote.configuration.Attribute;
import org.infinispan.loaders.remote.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.Element;
import org.infinispan.loaders.remote.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.ExhaustedAction;
import org.infinispan.loaders.remote.configuration.RemoteCacheStoreConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.RemoteServerConfigurationBuilder;
import org.infinispan.loaders.remote.wrapper.EntryWrapper;
import org.infinispan.util.StringPropertyReplacer;
import org.infinispan.util.Util;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class RemoteCacheStoreConfigurationParser52
implements ConfigurationParser<ConfigurationBuilderHolder> {
    private static final Namespace[] NAMESPACES = new Namespace[]{new Namespace("urn:infinispan:config", "remote", Element.REMOTE_STORE.getLocalName(), 5, 2), new Namespace("", Element.REMOTE_STORE.getLocalName(), 0, 0)};

    public Namespace[] getSupportedNamespaces() {
        return NAMESPACES;
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, builder.loaders(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder, ClassLoader classLoader) throws XMLStreamException {
        RemoteCacheStoreConfigurationBuilder builder = new RemoteCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseRemoteStoreAttributes(reader, builder, classLoader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC_TRANSPORT_EXECUTOR: {
                    this.parseAsyncTransportExecutor(reader, builder.asyncExecutorFactory(), classLoader);
                    continue block5;
                }
                case CONNECTION_POOL: {
                    this.parseConnectionPool(reader, builder.connectionPool());
                    continue block5;
                }
                case SERVERS: {
                    this.parseServers(reader, builder);
                    continue block5;
                }
            }
            Parser52.parseCommonStoreChildren((XMLExtendedStreamReader)reader, (CacheStoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseAsyncTransportExecutor(XMLExtendedStreamReader reader, ExecutorFactoryConfigurationBuilder builder, ClassLoader classLoader) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.factory((ExecutorFactory)Util.getInstance((String)value, (ClassLoader)classLoader));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.withExecutorProperties(Parser52.parseProperties((XMLExtendedStreamReader)reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseConnectionPool(XMLExtendedStreamReader reader, ConnectionPoolConfigurationBuilder builder) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case EXHAUSTED_ACTION: {
                    builder.exhaustedAction(ExhaustedAction.valueOf(value));
                    continue block10;
                }
                case MAX_ACTIVE: {
                    builder.maxActive(Integer.parseInt(value));
                    continue block10;
                }
                case MAX_IDLE: {
                    builder.maxIdle(Integer.parseInt(value));
                    continue block10;
                }
                case MAX_TOTAL: {
                    builder.maxTotal(Integer.parseInt(value));
                    continue block10;
                }
                case MIN_EVICTABLE_IDLE_TIME: {
                    builder.minEvictableIdleTime(Long.parseLong(value));
                    continue block10;
                }
                case MIN_IDLE: {
                    builder.minIdle(Integer.parseInt(value));
                    continue block10;
                }
                case TEST_WHILE_IDLE: {
                    builder.testWhileIdle(Boolean.parseBoolean(value));
                    continue block10;
                }
                case TIME_BETWEEN_EVICTION_RUNS: {
                    builder.timeBetweenEvictionRuns(Long.parseLong(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseServers(XMLExtendedStreamReader reader, RemoteCacheStoreConfigurationBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVER: {
                    this.parseServer(reader, builder.addServer());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseServer(XMLExtendedStreamReader reader, RemoteServerConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    builder.host(value);
                    continue block4;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseRemoteStoreAttributes(XMLExtendedStreamReader reader, RemoteCacheStoreConfigurationBuilder builder, ClassLoader classLoader) throws XMLStreamException {
        block17: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BALANCING_STRATEGY: {
                    builder.balancingStrategy(value);
                    continue block17;
                }
                case CONNECT_TIMEOUT: {
                    builder.connectionTimeout(Long.parseLong(value));
                    continue block17;
                }
                case ENTRY_WRAPPER: {
                    builder.entryWrapper((EntryWrapper)Util.getInstance((String)value, (ClassLoader)classLoader));
                    continue block17;
                }
                case FORCE_RETURN_VALUES: {
                    builder.forceReturnValues(Boolean.parseBoolean(value));
                    continue block17;
                }
                case HOTROD_WRAPPING: {
                    builder.hotRodWrapping(Boolean.parseBoolean(value));
                    continue block17;
                }
                case KEY_SIZE_ESTIMATE: {
                    builder.keySizeEstimate(Integer.parseInt(value));
                    continue block17;
                }
                case MARSHALLER: {
                    builder.marshaller(value);
                    continue block17;
                }
                case PING_ON_STARTUP: {
                    builder.pingOnStartup(Boolean.parseBoolean(value));
                    continue block17;
                }
                case PROTOCOL_VERSION: {
                    builder.protocolVersion(value);
                    continue block17;
                }
                case RAW_VALUES: {
                    builder.rawValues(Boolean.parseBoolean(value));
                    continue block17;
                }
                case REMOTE_CACHE_NAME: {
                    builder.remoteCacheName(value);
                    continue block17;
                }
                case SOCKET_TIMEOUT: {
                    builder.socketTimeout(Long.parseLong(value));
                    continue block17;
                }
                case TCP_NO_DELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    continue block17;
                }
                case TRANSPORT_FACTORY: {
                    builder.transportFactory(value);
                    continue block17;
                }
                case VALUE_SIZE_ESTIMATE: {
                    builder.valueSizeEstimate(Integer.parseInt(value));
                    continue block17;
                }
                default: {
                    Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
    }
}

