/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Util;

public class MergeView
extends View {
    protected List<View> subgroups = null;

    public MergeView() {
    }

    public MergeView(ViewId vid, List<Address> members, List<View> subgroups) {
        super(vid, members);
        this.subgroups = subgroups;
    }

    public MergeView(Address creator, long id, List<Address> members, List<View> subgroups) {
        super(creator, id, members);
        this.subgroups = subgroups;
    }

    public List<View> getSubgroups() {
        return this.subgroups;
    }

    @Override
    public View copy() {
        ViewId vid2 = this.vid.copy();
        ArrayList<Address> members2 = this.members != null ? new ArrayList<Address>(this.members) : null;
        ArrayList<View> subgroups2 = this.subgroups != null ? new ArrayList<View>(this.subgroups) : null;
        return new MergeView(vid2, members2, subgroups2);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MergeView::").append(super.toString());
        if (this.subgroups != null && !this.subgroups.isEmpty()) {
            sb.append(", subgroups=");
            sb.append(Util.printListWithDelimiter(this.subgroups, ", ", Util.MAX_LIST_PRINT_SIZE));
        }
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        int len = this.subgroups != null ? this.subgroups.size() : 0;
        out.writeShort(len);
        if (len == 0) {
            return;
        }
        for (View v : this.subgroups) {
            if (v instanceof MergeView) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
            }
            v.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        int len = in.readShort();
        if (len > 0) {
            this.subgroups = new ArrayList<View>(len);
            for (int i = 0; i < len; ++i) {
                boolean is_merge_view = in.readBoolean();
                View v = is_merge_view ? new MergeView() : new View();
                v.readFrom(in);
                this.subgroups.add(v);
            }
        }
    }

    @Override
    public int serializedSize() {
        int retval = super.serializedSize();
        retval += 2;
        if (this.subgroups == null) {
            return retval;
        }
        for (View v : this.subgroups) {
            ++retval;
            retval += v.serializedSize();
        }
        return retval;
    }
}

