/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Set;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;

public class SizeCommand
extends AbstractLocalCommand
implements VisitableCommand {
    private final DataContainer container;

    public SizeCommand(DataContainer container, Set<Flag> flags) {
        this.setFlags(flags);
        this.container = container;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitSizeCommand(ctx, this);
    }

    @Override
    public Integer perform(InvocationContext ctx) throws Throwable {
        if (this.noTxModifications(ctx)) {
            return this.container.size();
        }
        int size = this.container.size();
        for (CacheEntry e : ctx.getLookedUpEntries().values()) {
            if (e.isCreated()) {
                ++size;
                continue;
            }
            if (!e.isRemoved()) continue;
            --size;
        }
        return Math.max(size, 0);
    }

    public String toString() {
        return "SizeCommand{containerSize=" + this.container.size() + '}';
    }
}

