/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractLoaderConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;

public abstract class AbstractStoreConfiguration
extends AbstractLoaderConfiguration
implements CacheStoreConfiguration {
    private final boolean purgeOnStartup;
    private final boolean purgeSynchronously;
    private final int purgerThreads;
    private boolean fetchPersistentState;
    private boolean ignoreModifications;
    private final AsyncStoreConfiguration async;
    private final SingletonStoreConfiguration singletonStore;

    protected AbstractStoreConfiguration(boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(properties);
        this.purgeOnStartup = purgeOnStartup;
        this.purgeSynchronously = purgeSynchronously;
        this.purgerThreads = purgerThreads;
        this.fetchPersistentState = fetchPersistentState;
        this.ignoreModifications = ignoreModifications;
        this.async = async;
        this.singletonStore = singletonStore;
    }

    @Override
    public AsyncStoreConfiguration async() {
        return this.async;
    }

    @Override
    public SingletonStoreConfiguration singletonStore() {
        return this.singletonStore;
    }

    @Override
    public boolean purgeOnStartup() {
        return this.purgeOnStartup;
    }

    @Override
    public boolean purgeSynchronously() {
        return this.purgeSynchronously;
    }

    @Override
    public int purgerThreads() {
        return this.purgerThreads;
    }

    @Override
    public boolean fetchPersistentState() {
        return this.fetchPersistentState;
    }

    @Override
    public boolean ignoreModifications() {
        return this.ignoreModifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStoreConfiguration that = (AbstractStoreConfiguration)o;
        if (!super.equals((Object)that)) {
            return false;
        }
        if (this.fetchPersistentState != that.fetchPersistentState) {
            return false;
        }
        if (this.ignoreModifications != that.ignoreModifications) {
            return false;
        }
        if (this.purgeOnStartup != that.purgeOnStartup) {
            return false;
        }
        if (this.purgeSynchronously != that.purgeSynchronously) {
            return false;
        }
        if (this.purgerThreads != that.purgerThreads) {
            return false;
        }
        if (this.async != null ? !this.async.equals(that.async) : that.async != null) {
            return false;
        }
        return !(this.singletonStore != null ? !this.singletonStore.equals(that.singletonStore) : that.singletonStore != null);
    }

    public int hashCode() {
        int result = 31 * super.hashCode() + (this.purgeOnStartup ? 1 : 0);
        result = 31 * result + (this.purgeSynchronously ? 1 : 0);
        result = 31 * result + this.purgerThreads;
        result = 31 * result + (this.fetchPersistentState ? 1 : 0);
        result = 31 * result + (this.ignoreModifications ? 1 : 0);
        result = 31 * result + (this.async != null ? this.async.hashCode() : 0);
        result = 31 * result + (this.singletonStore != null ? this.singletonStore.hashCode() : 0);
        return result;
    }
}

