/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.OwnershipStatistics;
import org.infinispan.remoting.transport.Address;

public class DefaultConsistentHashFactory
implements ConsistentHashFactory<DefaultConsistentHash> {
    @Override
    public DefaultConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members) {
        if (numOwners <= 0) {
            throw new IllegalArgumentException("The number of owners should be greater than 0");
        }
        Builder builder = new Builder(hashFunction, numOwners, numSegments, members);
        this.rebalanceBuilder(builder);
        return builder.build();
    }

    @Override
    public DefaultConsistentHash updateMembers(DefaultConsistentHash baseCH, List<Address> actualMembers) {
        if (actualMembers.equals(baseCH.getMembers())) {
            return baseCH;
        }
        Builder builder = new Builder(baseCH, actualMembers);
        Builder balancedBuilder = null;
        for (int segment = 0; segment < baseCH.getNumSegments(); ++segment) {
            if (!builder.getOwners(segment).isEmpty()) continue;
            if (balancedBuilder == null) {
                balancedBuilder = new Builder(builder);
                this.rebalanceBuilder(balancedBuilder);
            }
            builder.addOwners(segment, balancedBuilder.getOwners(segment));
        }
        return builder.build();
    }

    @Override
    public DefaultConsistentHash rebalance(DefaultConsistentHash baseCH) {
        Builder builder = new Builder(baseCH);
        this.rebalanceBuilder(builder);
        DefaultConsistentHash balancedCH = builder.build();
        return balancedCH.equals(baseCH) ? baseCH : balancedCH;
    }

    @Override
    public DefaultConsistentHash union(DefaultConsistentHash dch1, DefaultConsistentHash dch2) {
        return dch1.union(dch2);
    }

    protected void rebalanceBuilder(Builder builder) {
        this.addPrimaryOwners(builder);
        this.addBackupOwners(builder);
    }

    protected void addPrimaryOwners(Builder builder) {
        int minPrimarySegments = builder.getNumSegments() / builder.getNumNodes();
        this.swapPrimaryOwnersWithBackups(builder, minPrimarySegments + 1);
        this.swapPrimaryOwnersWithBackups(builder, minPrimarySegments);
        this.swapPrimaryOwnersWithBackups(builder, minPrimarySegments + 1);
        int actualNumOwners = builder.getActualNumOwners();
        this.doAddPrimaryOwners(builder, minPrimarySegments + 1, actualNumOwners);
        this.doAddPrimaryOwners(builder, minPrimarySegments, actualNumOwners);
        this.doAddPrimaryOwners(builder, minPrimarySegments + 1, actualNumOwners);
        this.doAddPrimaryOwners(builder, minPrimarySegments + 1, actualNumOwners + 1);
        this.doAddPrimaryOwners(builder, minPrimarySegments, actualNumOwners + 1);
        this.doAddPrimaryOwners(builder, minPrimarySegments + 1, actualNumOwners + 1);
    }

    protected void doAddPrimaryOwners(Builder builder, int maxSegments, int maxOwners) {
        for (int segment = builder.getNumSegments() - 1; segment >= 0; --segment) {
            Address newPrimary;
            boolean zeroOwners;
            if (builder.getOwners(segment).size() >= maxOwners || !(zeroOwners = builder.getOwners(segment).isEmpty()) && builder.getPrimaryOwned(builder.getPrimaryOwner(segment)) <= maxSegments || (newPrimary = this.findNewPrimaryOwner(builder, builder.getMembers(), maxSegments)) == null) continue;
            builder.replacePrimaryOwner(segment, newPrimary);
        }
    }

    protected void swapPrimaryOwnersWithBackups(Builder builder, int maxSegments) {
        for (int segment = builder.getNumSegments() - 1; segment >= 0; --segment) {
            Address newPrimary;
            if (builder.getOwners(segment).isEmpty() || builder.getPrimaryOwned(builder.getPrimaryOwner(segment)) <= maxSegments || (newPrimary = this.findNewPrimaryOwner(builder, builder.getBackupOwners(segment), maxSegments)) == null) continue;
            builder.replacePrimaryOwner(segment, newPrimary);
        }
    }

    protected void addBackupOwners(Builder builder) {
        int minSegments = builder.getActualNumOwners() * builder.getNumSegments() / builder.getNumNodes();
        this.removeExtraBackupOwners(builder, minSegments);
        boolean insufficientOwners = true;
        int maxSegments = minSegments;
        while (insufficientOwners) {
            insufficientOwners = this.doAddBackupOwners(builder, maxSegments);
            ++maxSegments;
        }
        for (maxSegments = builder.getNumSegments() - 1; maxSegments >= minSegments; --maxSegments) {
            this.replaceBackupOwners(builder, maxSegments);
        }
        this.replaceBackupOwners(builder, minSegments + 1);
    }

    protected void removeExtraBackupOwners(Builder builder, int minSegments) {
        boolean tooManyOwners = true;
        int maxSegments = minSegments + 1;
        while (tooManyOwners) {
            tooManyOwners = this.doRemoveExtraBackupOwners(builder, maxSegments);
            --maxSegments;
        }
    }

    protected boolean doRemoveExtraBackupOwners(Builder builder, int maxSegments) {
        boolean tooManyOwners = false;
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            for (int ownerIdx = owners.size() - 1; ownerIdx >= 1 && owners.size() > builder.getActualNumOwners(); --ownerIdx) {
                Address owner = owners.get(ownerIdx);
                if (builder.getOwned(owner) <= maxSegments) continue;
                builder.removeOwner(segment, owner);
            }
            tooManyOwners |= builder.getOwners(segment).size() > builder.getActualNumOwners();
        }
        return tooManyOwners;
    }

    protected boolean doAddBackupOwners(Builder builder, int maxSegments) {
        boolean insufficientOwners = false;
        block0: for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            while (owners.size() < builder.getActualNumOwners()) {
                Address newOwner = this.findNewBackupOwner(builder, owners, maxSegments);
                if (newOwner == null) {
                    insufficientOwners = true;
                    continue block0;
                }
                builder.addOwner(segment, newOwner);
            }
        }
        return insufficientOwners;
    }

    protected void replaceBackupOwners(Builder builder, int maxSegments) {
        for (int ownerIdx = builder.getActualNumOwners() - 1; ownerIdx >= 0; --ownerIdx) {
            for (int segment = builder.getNumSegments() - 1; segment >= 0; --segment) {
                Address replacement;
                List<Address> owners = builder.getOwners(segment);
                Address owner = owners.get(ownerIdx);
                if (builder.getOwned(owner) <= maxSegments || (replacement = this.findNewBackupOwner(builder, owners, maxSegments)) == null) continue;
                builder.removeOwner(segment, owner);
                builder.addOwner(segment, replacement);
            }
        }
    }

    protected Address findNewBackupOwner(Builder builder, Collection<Address> excludes, int maxSegments) {
        Address best = null;
        int foundOwned = maxSegments;
        for (Address candidate : builder.getMembers()) {
            if (builder.getOwned(candidate) >= foundOwned || excludes != null && excludes.contains(candidate)) continue;
            best = candidate;
            foundOwned = builder.getOwned(candidate);
        }
        return best;
    }

    protected Address findNewPrimaryOwner(Builder builder, Collection<Address> candidates, int maxSegments) {
        Address best = null;
        int foundOwned = maxSegments;
        for (Address candidate : candidates) {
            if (builder.getPrimaryOwned(candidate) >= foundOwned) continue;
            best = candidate;
            foundOwned = builder.getPrimaryOwned(candidate);
        }
        return best;
    }

    public static class Externalizer
    extends AbstractExternalizer<DefaultConsistentHashFactory> {
        public void writeObject(ObjectOutput output, DefaultConsistentHashFactory chf) throws IOException {
        }

        public DefaultConsistentHashFactory readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            return new DefaultConsistentHashFactory();
        }

        public Integer getId() {
            return 91;
        }

        public Set<Class<? extends DefaultConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(DefaultConsistentHashFactory.class);
        }
    }

    protected static class Builder {
        private final Hash hashFunction;
        private final int initialNumOwners;
        private final int actualNumOwners;
        private final List<Address>[] segmentOwners;
        private final OwnershipStatistics stats;
        private final List<Address> members;

        public Builder(Hash hashFunction, int numOwners, int numSegments, List<Address> members) {
            this.hashFunction = hashFunction;
            this.initialNumOwners = numOwners;
            this.actualNumOwners = Math.min(numOwners, members.size());
            this.members = members;
            this.segmentOwners = new List[numSegments];
            for (int segment = 0; segment < numSegments; ++segment) {
                this.segmentOwners[segment] = new ArrayList<Address>(this.actualNumOwners);
            }
            this.stats = new OwnershipStatistics(members);
        }

        public Builder(DefaultConsistentHash baseCH, List<Address> actualMembers) {
            int numSegments = baseCH.getNumSegments();
            HashSet<Address> actualMembersSet = new HashSet<Address>(actualMembers);
            List[] owners = new List[numSegments];
            for (int segment = 0; segment < numSegments; ++segment) {
                owners[segment] = new ArrayList<Address>(baseCH.locateOwnersForSegment(segment));
                owners[segment].retainAll(actualMembersSet);
            }
            this.hashFunction = baseCH.getHashFunction();
            this.initialNumOwners = baseCH.getNumOwners();
            this.actualNumOwners = Math.min(this.initialNumOwners, actualMembers.size());
            this.members = actualMembers;
            this.segmentOwners = owners;
            this.stats = new OwnershipStatistics(baseCH, actualMembers);
        }

        public Builder(DefaultConsistentHash baseCH) {
            this(baseCH, baseCH.getMembers());
        }

        public Builder(Builder other) {
            int numSegments = other.getNumSegments();
            List[] owners = new List[numSegments];
            for (int segment = 0; segment < numSegments; ++segment) {
                owners[segment] = new ArrayList<Address>(other.segmentOwners[segment]);
            }
            this.hashFunction = other.hashFunction;
            this.initialNumOwners = other.initialNumOwners;
            this.actualNumOwners = other.actualNumOwners;
            this.members = other.members;
            this.segmentOwners = owners;
            this.stats = new OwnershipStatistics(other.stats);
        }

        public int getActualNumOwners() {
            return this.actualNumOwners;
        }

        public int getNumSegments() {
            return this.segmentOwners.length;
        }

        public List<Address> getMembers() {
            return this.members;
        }

        public int getNumNodes() {
            return this.getMembers().size();
        }

        public List<Address> getOwners(int segment) {
            return this.segmentOwners[segment];
        }

        public Address getPrimaryOwner(int segment) {
            return this.segmentOwners[segment].get(0);
        }

        public List<Address> getBackupOwners(int segment) {
            return this.segmentOwners[segment].subList(1, this.segmentOwners[segment].size());
        }

        public boolean addOwner(int segment, Address owner) {
            List<Address> thisSegmentOwners = this.segmentOwners[segment];
            if (thisSegmentOwners.contains(owner)) {
                return false;
            }
            thisSegmentOwners.add(owner);
            this.stats.incOwned(owner);
            if (thisSegmentOwners.size() == 1) {
                this.stats.incPrimaryOwned(owner);
            }
            return true;
        }

        public boolean addOwners(int segment, Collection<Address> newOwners) {
            boolean modified = false;
            for (Address owner : newOwners) {
                modified |= this.addOwner(segment, owner);
            }
            return modified;
        }

        public boolean removeOwner(int segment, Address owner) {
            boolean modified;
            List<Address> segmentOwners = this.segmentOwners[segment];
            if (segmentOwners.get(0).equals(owner)) {
                this.stats.decPrimaryOwned(owner);
            }
            if (modified = segmentOwners.remove(owner)) {
                this.stats.decOwned(owner);
            }
            return modified;
        }

        public void replacePrimaryOwner(int segment, Address newPrimaryOwner) {
            List<Address> segmentOwners = this.segmentOwners[segment];
            int ownerIndex = segmentOwners.indexOf(newPrimaryOwner);
            if (ownerIndex == 0) {
                throw new IllegalStateException("Can't replace a primary owner with itself");
            }
            if (segmentOwners.isEmpty()) {
                segmentOwners.add(newPrimaryOwner);
                this.stats.incOwned(newPrimaryOwner);
                this.stats.incPrimaryOwned(newPrimaryOwner);
                return;
            }
            Address oldPrimaryOwner = segmentOwners.get(0);
            if (ownerIndex == -1) {
                this.stats.incOwned(newPrimaryOwner);
            } else {
                segmentOwners.remove(ownerIndex);
            }
            segmentOwners.add(0, newPrimaryOwner);
            this.stats.decPrimaryOwned(oldPrimaryOwner);
            this.stats.incPrimaryOwned(newPrimaryOwner);
        }

        public DefaultConsistentHash build() {
            return new DefaultConsistentHash(this.hashFunction, this.initialNumOwners, this.segmentOwners.length, this.members, this.segmentOwners);
        }

        private int getPrimaryOwned(Address node) {
            return this.stats.getPrimaryOwned(node);
        }

        public int getOwned(Address node) {
            return this.stats.getOwned(node);
        }
    }
}

