/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.LoadersConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.decorators.AbstractDelegatingStore;
import org.infinispan.loaders.decorators.AsyncStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.decorators.ReadOnlyStore;
import org.infinispan.loaders.decorators.SingletonStore;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheLoader;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheLoaderManagerImpl
implements CacheLoaderManager {
    Configuration configuration;
    LoadersConfiguration clmConfig;
    AdvancedCache<Object, Object> cache;
    StreamingMarshaller m;
    CacheLoader loader;
    InvocationContextContainer icc;
    TransactionManager transactionManager;
    private TimeService timeService;
    private static final Log log = LogFactory.getLog(CacheLoaderManagerImpl.class);

    @Inject
    public void inject(AdvancedCache<Object, Object> cache, @ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, Configuration configuration, InvocationContextContainer icc, TransactionManager transactionManager, TimeService timeService) {
        this.cache = cache;
        this.m = marshaller;
        this.configuration = configuration;
        this.icc = icc;
        this.transactionManager = transactionManager;
        this.timeService = timeService;
    }

    @Override
    public CacheLoader getCacheLoader() {
        return this.loader;
    }

    @Override
    public final CacheStore getCacheStore() {
        if (this.loader != null && this.loader instanceof CacheStore) {
            return (CacheStore)this.loader;
        }
        return null;
    }

    @Override
    public void purge() {
        CacheStore cs = this.getCacheStore();
        if (cs != null) {
            try {
                cs.clear();
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Unable to purge cache store", (Throwable)e);
            }
        }
    }

    private void purgeLoaders(boolean force) throws Exception {
        CacheStore cs = this.getCacheStore();
        if (cs != null) {
            if (cs instanceof ChainingCacheStore && !force) {
                ((ChainingCacheStore)this.loader).purgeIfNecessary();
            } else {
                CacheLoaderConfiguration first = this.clmConfig.cacheLoaders().get(0);
                if (force || first != null && first instanceof CacheStoreConfiguration && ((CacheStoreConfiguration)first).purgeOnStartup()) {
                    cs.clear();
                }
            }
        }
    }

    @Override
    public boolean isUsingPassivation() {
        return this.isEnabled() ? this.clmConfig.passivation() : false;
    }

    @Override
    public boolean isShared() {
        return this.isEnabled() ? this.clmConfig.shared() : false;
    }

    @Override
    public boolean isFetchPersistentState() {
        return this.isEnabled() ? this.clmConfig.fetchPersistentState() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Start(priority=10)
    public void start() {
        this.clmConfig = this.configuration.loaders();
        if (this.clmConfig != null) {
            try {
                this.loader = this.createCacheLoader();
                Transaction xaTx = null;
                if (this.transactionManager != null) {
                    xaTx = this.transactionManager.suspend();
                }
                try {
                    if (this.loader != null) {
                        this.loader.start();
                    }
                }
                finally {
                    if (this.transactionManager != null && xaTx != null) {
                        this.transactionManager.resume(xaTx);
                    }
                }
                this.purgeLoaders(false);
            }
            catch (Exception e) {
                throw new CacheException("Unable to start cache loaders", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.clmConfig != null;
    }

    @Override
    public void disableCacheStore(String loaderType) {
        if (this.isEnabled()) {
            boolean disableInterceptors = false;
            ComponentRegistry cr = this.cache.getComponentRegistry();
            CacheLoaderInterceptor cli = cr.getComponent(CacheLoaderInterceptor.class);
            CacheStoreInterceptor csi = cr.getComponent(CacheStoreInterceptor.class);
            if (this.loader instanceof ChainingCacheStore) {
                ChainingCacheStore ccs = (ChainingCacheStore)this.loader;
                ccs.removeCacheLoader(loaderType);
                if (ccs.getStores().isEmpty()) {
                    disableInterceptors = true;
                }
            } else {
                String loaderClassName = AbstractDelegatingStore.undelegateCacheLoader(this.loader).getClass().getName();
                if (loaderClassName.equals(loaderType)) {
                    try {
                        log.debugf("Stopping and removing cache loader %s", loaderType);
                        this.loader.stop();
                    }
                    catch (Exception e) {
                        log.infof("Problems shutting down cache loader %s", loaderType, e);
                    }
                    disableInterceptors = true;
                }
            }
            if (disableInterceptors) {
                cli.disableInterceptor();
                csi.disableInterceptor();
                this.cache.removeInterceptor(cli.getClass());
                this.cache.removeInterceptor(csi.getClass());
                this.clmConfig = null;
            }
        }
    }

    @Override
    public <T extends CacheLoader> List<T> getCacheLoaders(Class<T> loaderClass) {
        List<Object> loaders;
        if (this.loader instanceof ChainingCacheStore) {
            ChainingCacheStore ccs = (ChainingCacheStore)this.loader;
            loaders = ccs.getCacheLoaders(loaderClass);
        } else {
            CacheLoader cl = AbstractDelegatingStore.undelegateCacheLoader(this.loader);
            loaders = loaderClass.isInstance(cl) ? Collections.singletonList(cl) : Collections.emptyList();
        }
        return loaders;
    }

    @Override
    @Start(priority=56)
    public void preload() {
        if (this.loader != null && this.clmConfig.preload()) {
            Set<InternalCacheEntry> state;
            long start = 0L;
            boolean debugTiming = log.isDebugEnabled();
            if (debugTiming) {
                start = this.timeService.time();
                log.debugf("Preloading transient state from cache loader %s", this.loader);
            }
            try {
                state = this.loadState();
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Unable to preload!", (Throwable)e);
            }
            ArrayList<Flag> flags = new ArrayList<Flag>(Arrays.asList(Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK, Flag.IGNORE_RETURN_VALUES, Flag.SKIP_CACHE_STORE, Flag.SKIP_LOCKING));
            if (this.clmConfig.shared() || !(this.loader instanceof ChainingCacheStore)) {
                flags.add(Flag.SKIP_CACHE_STORE);
                if (!this.localIndexingEnabled()) {
                    flags.add(Flag.SKIP_INDEXING);
                }
            } else {
                flags.add(Flag.SKIP_INDEXING);
            }
            AdvancedCache<Object, Object> flaggedCache = this.cache.getAdvancedCache().withFlags(flags.toArray(new Flag[flags.size()]));
            for (InternalCacheEntry e : state) {
                flaggedCache.put(e.getKey(), e.getValue(), e.getMetadata());
            }
            if (debugTiming) {
                log.debugf("Preloaded %s keys in %s", state.size(), Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
            }
        }
    }

    private boolean localIndexingEnabled() {
        return this.configuration.indexing().enabled() && this.configuration.indexing().indexLocalOnly();
    }

    private Set<InternalCacheEntry> loadState() throws CacheLoaderException {
        Set<InternalCacheEntry> state;
        int ne = -1;
        if (this.configuration.eviction().strategy().isEnabled()) {
            ne = this.configuration.eviction().maxEntries();
        }
        switch (ne) {
            case -1: {
                state = this.loader.loadAll();
                break;
            }
            case 0: {
                state = InfinispanCollections.emptySet();
                break;
            }
            default: {
                state = this.loader.load(ne);
            }
        }
        return state;
    }

    @Override
    @Stop
    public void stop() {
        if (this.loader != null) {
            try {
                this.loader.stop();
            }
            catch (CacheLoaderException e) {
                throw new CacheException((Throwable)e);
            }
            finally {
                this.loader = null;
            }
        }
    }

    CacheLoader createCacheLoader() throws Exception {
        CacheLoader tmpLoader;
        if (this.clmConfig.usingChainingCacheLoader()) {
            ChainingCacheStore ccl;
            tmpLoader = ccl = new ChainingCacheStore();
            int numLoadersWithFetchPersistentState = 0;
            for (CacheLoaderConfiguration cfg : this.clmConfig.cacheLoaders()) {
                if (cfg instanceof CacheStoreConfiguration) {
                    CacheStoreConfiguration scfg = (CacheStoreConfiguration)cfg;
                    this.assertNotSingletonAndShared(scfg);
                    if (scfg.fetchPersistentState()) {
                        ++numLoadersWithFetchPersistentState;
                    }
                }
                if (numLoadersWithFetchPersistentState > 1) {
                    throw log.multipleCacheStoresWithFetchPersistentState();
                }
                CacheLoader l = this.createCacheLoader(cfg, this.cache);
                ccl.addCacheLoader(l);
            }
        } else if (!this.clmConfig.cacheLoaders().isEmpty()) {
            CacheLoaderConfiguration cfg = this.clmConfig.cacheLoaders().get(0);
            if (cfg instanceof CacheStoreConfiguration) {
                this.assertNotSingletonAndShared((CacheStoreConfiguration)cfg);
            }
            tmpLoader = this.createCacheLoader(cfg, this.cache);
        } else {
            return null;
        }
        return tmpLoader;
    }

    CacheLoader createCacheLoader(CacheLoaderConfiguration cfg, AdvancedCache<Object, Object> cache) throws Exception {
        ConfigurationFor annotation = cfg.getClass().getAnnotation(ConfigurationFor.class);
        if (annotation == null) {
            throw log.loaderConfigurationDoesNotSpecifyLoaderClass(cfg.getClass().getName());
        }
        CacheLoader tmpLoader = (CacheLoader)Util.getInstance((Class)annotation.value());
        if (tmpLoader != null) {
            if (cfg instanceof CacheStoreConfiguration) {
                CacheStore tmpStore = (CacheStore)tmpLoader;
                CacheStoreConfiguration cfg2 = (CacheStoreConfiguration)cfg;
                if (cfg2.async().enabled()) {
                    tmpStore = this.createAsyncStore(tmpStore);
                    tmpLoader = tmpStore;
                }
                if (cfg2.ignoreModifications()) {
                    tmpStore = new ReadOnlyStore(tmpStore);
                    tmpLoader = tmpStore;
                }
                if (cfg2.singletonStore().enabled()) {
                    tmpStore = new SingletonStore(tmpStore, cache);
                    tmpLoader = tmpStore;
                }
            }
            tmpLoader.init(cfg, cache, this.m);
        }
        return tmpLoader;
    }

    protected AsyncStore createAsyncStore(CacheStore tmpStore) {
        return new AsyncStore(tmpStore);
    }

    void assertNotSingletonAndShared(CacheStoreConfiguration cfg) {
        if (cfg.singletonStore().enabled() && this.clmConfig.shared()) {
            throw new CacheConfigurationException("Invalid cache loader configuration!!  If a cache loader is configured as a singleton, the cache loader cannot be shared in a cluster!");
        }
    }
}

