/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.AffectedKeysVisitor;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferInterceptor
extends CommandInterceptor {
    private static final Log log = LogFactory.getLog(StateTransferInterceptor.class);
    private StateTransferLock stateTransferLock;
    private StateTransferManager stateTransferManager;
    private CommandsFactory commandFactory;
    private boolean useVersioning;
    private final AffectedKeysVisitor affectedKeysVisitor = new AffectedKeysVisitor();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(StateTransferLock stateTransferLock, Configuration configuration, CommandsFactory commandFactory, StateTransferManager stateTransferManager) {
        this.stateTransferLock = stateTransferLock;
        this.commandFactory = commandFactory;
        this.stateTransferManager = stateTransferManager;
        this.useVersioning = configuration.transaction().transactionMode().isTransactional() && configuration.locking().writeSkewCheck() && configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC && configuration.versioning().enabled();
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.getCacheTransaction() instanceof RemoteTransaction) {
            ((RemoteTransaction)ctx.getCacheTransaction()).setMissingLookedUpEntries(false);
        }
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        RemoteTransaction remoteTx;
        if (ctx.getCacheTransaction() instanceof RemoteTransaction && (remoteTx = (RemoteTransaction)ctx.getCacheTransaction()).isMissingLookedUpEntries()) {
            remoteTx.setMissingLookedUpEntries(false);
            PrepareCommand prepareCommand = this.useVersioning ? this.commandFactory.buildVersionedPrepareCommand(ctx.getGlobalTransaction(), ctx.getModifications(), false) : this.commandFactory.buildPrepareCommand(ctx.getGlobalTransaction(), ctx.getModifications(), false);
            this.commandFactory.initializeReplicableCommand(prepareCommand, true);
            prepareCommand.setOrigin(ctx.getOrigin());
            log.tracef("Replaying the transactions received as a result of state transfer %s", prepareCommand);
            prepareCommand.perform(null);
        }
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object handleTxCommand(TxInvocationContext ctx, TransactionBoundaryCommand command) throws Throwable {
        Address address = ctx.isOriginLocal() ? ctx.getOrigin() : ctx.getGlobalTransaction().getAddress();
        return this.handleTopologyAffectedCommand(ctx, command, address, true);
    }

    private Object handleWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        return this.handleTopologyAffectedCommand(ctx, command, ctx.getOrigin(), false);
    }

    @Override
    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (command instanceof TopologyAffectedCommand) {
            return this.handleTopologyAffectedCommand(ctx, command, ctx.getOrigin(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object handleTopologyAffectedCommand(InvocationContext ctx, VisitableCommand command, Address origin, boolean sync) throws Throwable {
        log.tracef("handleTopologyAffectedCommand for command %s", command);
        if (this.isLocalOnly(ctx, command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        this.updateTopologyIdAndWaitForTransactionData((TopologyAffectedCommand)((Object)command));
        Object localResult = this.invokeNextWithRetry(ctx, command);
        boolean isNonTransactionalWrite = !ctx.isInTxScope() && command instanceof WriteCommand;
        boolean isTransactionalAndNotRolledBack = false;
        if (ctx.isInTxScope()) {
            boolean bl = isTransactionalAndNotRolledBack = !((TxInvocationContext)ctx).getCacheTransaction().isMarkedForRollback();
        }
        if (isNonTransactionalWrite || isTransactionalAndNotRolledBack) {
            this.stateTransferManager.forwardCommandIfNeeded((TopologyAffectedCommand)((Object)command), this.getAffectedKeys(ctx, command), origin, sync);
        }
        return localResult;
    }

    private Object invokeNextWithRetry(InvocationContext ctx, VisitableCommand command) throws Throwable {
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (OutdatedTopologyException e) {
            log.debugf("Retrying command because of topology change: %s", command);
            return this.invokeNextWithRetry(ctx, command);
        }
    }

    private void updateTopologyIdAndWaitForTransactionData(TopologyAffectedCommand command) throws InterruptedException {
        CacheTopology cacheTopology;
        if (command.getTopologyId() == -1 && (cacheTopology = this.stateTransferManager.getCacheTopology()) != null) {
            command.setTopologyId(cacheTopology.getTopologyId());
        }
        int cmdTopologyId = command.getTopologyId();
        this.stateTransferLock.waitForTransactionData(cmdTopologyId);
    }

    private boolean isLocalOnly(InvocationContext ctx, VisitableCommand command) {
        boolean transactionalWrite = ctx.isInTxScope() && command instanceof WriteCommand;
        boolean cacheModeLocal = false;
        if (command instanceof FlagAffectedCommand) {
            cacheModeLocal = ((FlagAffectedCommand)command).hasFlag(Flag.CACHE_MODE_LOCAL);
        }
        return cacheModeLocal || transactionalWrite;
    }

    private Set<Object> getAffectedKeys(InvocationContext ctx, VisitableCommand command) {
        Set affectedKeys = null;
        try {
            affectedKeys = (Set)command.acceptVisitor(ctx, this.affectedKeysVisitor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (affectedKeys == null) {
            affectedKeys = InfinispanCollections.emptySet();
        }
        return affectedKeys;
    }
}

