/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import java.lang.reflect.Constructor;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.AbstractLockSupportStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcCacheStoreConfigurationChildBuilder;
import org.infinispan.loaders.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.SimpleConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.logging.Log;

public abstract class AbstractJdbcCacheStoreConfigurationBuilder<T extends AbstractJdbcCacheStoreConfiguration, S extends AbstractJdbcCacheStoreConfigurationBuilder<T, S>>
extends AbstractLockSupportStoreConfigurationBuilder<T, S>
implements JdbcCacheStoreConfigurationChildBuilder<S> {
    private static final Log log = (Log)LogFactory.getLog(AbstractJdbcCacheStoreConfigurationBuilder.class, Log.class);
    protected ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration> connectionFactory;
    protected boolean manageConnectionFactory = true;

    public AbstractJdbcCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public PooledConnectionFactoryConfigurationBuilder<S> connectionPool() {
        return (PooledConnectionFactoryConfigurationBuilder)((Object)this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)PooledConnectionFactoryConfigurationBuilder.class)));
    }

    @Override
    public ManagedConnectionFactoryConfigurationBuilder<S> dataSource() {
        return (ManagedConnectionFactoryConfigurationBuilder)((Object)this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)ManagedConnectionFactoryConfigurationBuilder.class)));
    }

    @Override
    public SimpleConnectionFactoryConfigurationBuilder<S> simpleConnection() {
        return (SimpleConnectionFactoryConfigurationBuilder)((Object)this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)SimpleConnectionFactoryConfigurationBuilder.class)));
    }

    public <C extends ConnectionFactoryConfigurationBuilder<?>> C connectionFactory(Class<C> klass) {
        if (this.connectionFactory != null) {
            throw new IllegalStateException("A ConnectionFactory has already been configured for this store");
        }
        try {
            ConnectionFactoryConfigurationBuilder builder;
            Constructor<C> constructor = klass.getDeclaredConstructor(AbstractJdbcCacheStoreConfigurationBuilder.class);
            this.connectionFactory = builder = (ConnectionFactoryConfigurationBuilder)constructor.newInstance(this);
            return (C)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate loader configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    public <C extends ConnectionFactoryConfigurationBuilder<?>> C connectionFactory(C builder) {
        if (this.connectionFactory != null) {
            throw new IllegalStateException("A ConnectionFactory has already been configured for this store");
        }
        this.connectionFactory = builder;
        return builder;
    }

    public S manageConnectionFactory(boolean manageConnectionFactory) {
        this.manageConnectionFactory = manageConnectionFactory;
        return (S)((AbstractJdbcCacheStoreConfigurationBuilder)this.self());
    }

    public void validate() {
        super.validate();
        if (this.manageConnectionFactory && this.connectionFactory == null) {
            throw log.missingConnectionFactory();
        }
        if (!this.manageConnectionFactory && this.connectionFactory != null) {
            throw log.unmanagedConnectionFactory();
        }
    }

    protected S readInternal(AbstractJdbcCacheStoreConfiguration template) {
        Class cfb = ConfigurationUtils.builderFor((Object)template.connectionFactory());
        this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)cfb));
        this.connectionFactory.read(template.connectionFactory());
        this.manageConnectionFactory = template.manageConnectionFactory();
        this.lockAcquistionTimeout = template.lockAcquistionTimeout();
        this.lockConcurrencyLevel = template.lockConcurrencyLevel();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return (S)((AbstractJdbcCacheStoreConfigurationBuilder)this.self());
    }
}

