/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.ReversibleOrderedSet;
import org.infinispan.commons.util.Util;

public class InfinispanCollections {
    private static final Set EMPTY_SET = new EmptySet();
    private static final Map EMPTY_MAP = new EmptyMap();
    private static final List EMPTY_LIST = new EmptyList();
    private static final ReversibleOrderedSet<Object> EMPTY_ROS = new EmptyReversibleOrderedSet<Object>();

    public static <K, V, E> Map<K, V> transformMapValue(Map<K, E> input, Function<E, V> f) {
        if (input.isEmpty()) {
            return InfinispanCollections.emptyMap();
        }
        if (input.size() == 1) {
            Map.Entry<K, E> single = input.entrySet().iterator().next();
            return Collections.singletonMap(single.getKey(), f.transform(single.getValue()));
        }
        HashMap<K, V> copy = new HashMap<K, V>(input.size());
        for (Map.Entry<K, E> entry : input.entrySet()) {
            copy.put(entry.getKey(), f.transform(entry.getValue()));
        }
        return Collections.unmodifiableMap(copy);
    }

    public static <K, V, E> Map<K, V> transformCollectionToMap(Collection<E> input, MapMakerFunction<K, V, E> f) {
        if (input.isEmpty()) {
            return InfinispanCollections.emptyMap();
        }
        if (input.size() == 1) {
            E single = input.iterator().next();
            Map.Entry<K, V> entry = f.transform(single);
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> map = new HashMap<K, V>(input.size());
        for (E e : input) {
            Map.Entry<K, V> entry = f.transform(e);
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static <E> Set<E> difference(Set<E> s1, Set<E> s2) {
        HashSet<E> copy1 = new HashSet<E>(s1);
        copy1.removeAll(new HashSet<E>(s2));
        return copy1;
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static final <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static interface MapMakerFunction<K, V, E> {
        public Map.Entry<K, V> transform(E var1);
    }

    public static interface Function<E, T> {
        public T transform(E var1);
    }

    private static final class EmptyReversibleOrderedSet<E>
    extends AbstractSet<E>
    implements ReversibleOrderedSet<E> {
        Iterator<E> it = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public E next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };

        private EmptyReversibleOrderedSet() {
        }

        @Override
        public Iterator<E> iterator() {
            return this.it;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> reverseIterator() {
            return this.it;
        }
    }

    public static final class EmptyList
    extends AbstractList<Object>
    implements RandomAccess {
        private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        public static final class EmptyListExternalizer
        extends AbstractExternalizer<List> {
            @Override
            public Integer getId() {
                return 90;
            }

            @Override
            public void writeObject(ObjectOutput output, List object) {
            }

            @Override
            public List readObject(ObjectInput input) {
                return EMPTY_LIST;
            }

            @Override
            public Set<Class<? extends List>> getTypeClasses() {
                return Util.asSet(EmptyList.class);
            }
        }
    }

    public static final class EmptyMap
    extends AbstractMap<Object, Object> {
        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Set<Object> keySet() {
            return EMPTY_SET;
        }

        @Override
        public Collection<Object> values() {
            return EMPTY_SET;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return EMPTY_SET;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).size() == 0;
        }

        public static final class EmptyMapExternalizer
        extends AbstractExternalizer<Map> {
            @Override
            public Integer getId() {
                return 89;
            }

            @Override
            public void writeObject(ObjectOutput output, Map object) {
            }

            @Override
            public Map readObject(ObjectInput input) {
                return EMPTY_MAP;
            }

            @Override
            public Set<Class<? extends Map>> getTypeClasses() {
                return Util.asSet(EmptyMap.class);
            }
        }
    }

    public static final class EmptySet
    extends AbstractSet<Object> {
        private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };

        @Override
        public Iterator<Object> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        public static final class EmptySetExternalizer
        extends AbstractExternalizer<Set> {
            @Override
            public Integer getId() {
                return 88;
            }

            @Override
            public void writeObject(ObjectOutput output, Set object) {
            }

            @Override
            public Set readObject(ObjectInput input) {
                return EMPTY_SET;
            }

            @Override
            public Set<Class<? extends Set>> getTypeClasses() {
                return Util.asSet(EmptySet.class);
            }
        }
    }
}

