/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.util.Properties;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;

public class JdbcBinaryStoreConfigurationBuilder
extends AbstractJdbcStoreConfigurationBuilder<JdbcBinaryStoreConfiguration, JdbcBinaryStoreConfigurationBuilder> {
    public static final int DEFAULT_CONCURRENCY_LEVEL = 2048;
    public static final int DEFAULT_LOCK_ACQUISITION_TIMEOUT = 60000;
    protected final BinaryTableManipulationConfigurationBuilder table = new BinaryTableManipulationConfigurationBuilder(this);
    private int concurrencyLevel = 2048;
    private long lockAcquisitionTimeout = 60000L;

    public JdbcBinaryStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    public JdbcBinaryStoreConfigurationBuilder self() {
        return this;
    }

    public BinaryTableManipulationConfigurationBuilder table() {
        return this.table;
    }

    @Override
    public void validate() {
        super.validate();
    }

    public JdbcBinaryStoreConfigurationBuilder lockAcquisitionTimeout(long lockAcquisitionTimeout) {
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
        return this.self();
    }

    public JdbcBinaryStoreConfigurationBuilder concurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
        return this.self();
    }

    public JdbcBinaryStoreConfiguration create() {
        ConnectionFactoryConfiguration cf = this.connectionFactory != null ? (ConnectionFactoryConfiguration)this.connectionFactory.create() : null;
        return new JdbcBinaryStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, (Properties)TypedProperties.toTypedProperties((Properties)this.properties), cf, this.manageConnectionFactory, this.table.create(), this.concurrencyLevel, this.lockAcquisitionTimeout);
    }

    public JdbcBinaryStoreConfigurationBuilder read(JdbcBinaryStoreConfiguration template) {
        super.readInternal(template);
        this.table.read(template.table());
        this.lockAcquisitionTimeout = template.lockAcquisitionTimeout();
        this.concurrencyLevel = template.lockConcurrencyLevel();
        return this;
    }

    public class BinaryTableManipulationConfigurationBuilder
    extends TableManipulationConfigurationBuilder<JdbcBinaryStoreConfigurationBuilder, BinaryTableManipulationConfigurationBuilder> {
        BinaryTableManipulationConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, JdbcBinaryStoreConfigurationBuilder> builder) {
            super(builder);
        }

        @Override
        public PooledConnectionFactoryConfigurationBuilder<JdbcBinaryStoreConfigurationBuilder> connectionPool() {
            return JdbcBinaryStoreConfigurationBuilder.this.connectionPool();
        }

        @Override
        public ManagedConnectionFactoryConfigurationBuilder<JdbcBinaryStoreConfigurationBuilder> dataSource() {
            return JdbcBinaryStoreConfigurationBuilder.this.dataSource();
        }

        public BinaryTableManipulationConfigurationBuilder self() {
            return this;
        }
    }
}

