/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree;

import org.infinispan.AdvancedCache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.batch.BatchContainer;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.NodeKey;
import org.infinispan.tree.TreeCache;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TreeStructureSupport
extends AutoBatchSupport {
    private static final Log log = LogFactory.getLog(TreeStructureSupport.class);
    protected final AdvancedCache<NodeKey, AtomicMap<?, ?>> cache;

    public TreeStructureSupport(AdvancedCache<?, ?> cache, BatchContainer batchContainer) {
        this.cache = cache;
        this.batchContainer = batchContainer;
    }

    public boolean exists(Fqn f) {
        return this.exists(this.cache, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(AdvancedCache<?, ?> cache, Fqn f) {
        this.startAtomic();
        try {
            boolean bl = cache.containsKey((Object)new NodeKey(f, NodeKey.Type.DATA)) && cache.containsKey((Object)new NodeKey(f, NodeKey.Type.STRUCTURE));
            return bl;
        }
        finally {
            this.endAtomic();
        }
    }

    boolean createNodeInCache(Fqn fqn) {
        return this.createNodeInCache(this.cache, fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createNodeInCache(AdvancedCache<?, ?> cache, Fqn fqn) {
        this.startAtomic();
        try {
            NodeKey dataKey = new NodeKey(fqn, NodeKey.Type.DATA);
            NodeKey structureKey = new NodeKey(fqn, NodeKey.Type.STRUCTURE);
            if (cache.containsKey((Object)dataKey) && cache.containsKey((Object)structureKey)) {
                boolean bl = false;
                return bl;
            }
            Fqn parent = fqn.getParent();
            if (!fqn.isRoot()) {
                if (!this.exists(cache, parent)) {
                    this.createNodeInCache(cache, parent);
                }
                AtomicMap<Object, Fqn> parentStructure = this.getStructure(cache, parent);
                parentStructure.put(fqn.getLastElement(), (Object)fqn);
            }
            this.getAtomicMap(cache, structureKey);
            this.getAtomicMap(cache, dataKey);
            if (log.isTraceEnabled()) {
                log.tracef("Created node %s", (Object)fqn);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.endAtomic();
        }
    }

    private AtomicMap<Object, Fqn> getStructure(AdvancedCache<?, ?> cache, Fqn fqn) {
        return this.getAtomicMap(cache, new NodeKey(fqn, NodeKey.Type.STRUCTURE));
    }

    public static boolean isLocked(LockManager lockManager, Fqn fqn) {
        return lockManager.isLocked((Object)new NodeKey(fqn, NodeKey.Type.STRUCTURE)) && lockManager.isLocked((Object)new NodeKey(fqn, NodeKey.Type.DATA));
    }

    public static String printTree(TreeCache<?, ?> cache, boolean details) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        sb.append("+ ").append("/");
        if (details) {
            sb.append("  ").append(cache.getRoot().getData());
        }
        sb.append("\n");
        TreeStructureSupport.addChildren(cache.getRoot(), 1, sb, details);
        return sb.toString();
    }

    private static void addChildren(Node<?, ?> node, int depth, StringBuilder sb, boolean details) {
        for (Node<?, ?> child : node.getChildren()) {
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            sb.append("+ ");
            sb.append(child.getFqn().getLastElementAsString()).append("/");
            if (details) {
                sb.append("  ").append(child.getData());
            }
            sb.append("\n");
            TreeStructureSupport.addChildren(child, depth + 1, sb, details);
        }
    }

    protected final <K, V> AtomicMap<K, V> getAtomicMap(NodeKey key) {
        return AtomicMapLookup.getAtomicMap(this.cache, (Object)key);
    }

    protected final <K, V> AtomicMap<K, V> getAtomicMap(AdvancedCache<?, ?> cache, NodeKey key) {
        return AtomicMapLookup.getAtomicMap(cache, (Object)key);
    }
}

