/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.compat;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.Immutables;
import org.infinispan.compat.TypeConverter;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.TimeService;

public abstract class BaseTypeConverterInterceptor
extends CommandInterceptor {
    private InternalEntryFactory entryFactory;
    private VersionGenerator versionGenerator;
    private TimeService timerService;

    @Inject
    protected void init(InternalEntryFactory entryFactory, VersionGenerator versionGenerator, TimeService timeService) {
        this.entryFactory = entryFactory;
        this.versionGenerator = versionGenerator;
        this.timerService = timeService;
    }

    protected abstract TypeConverter<Object, Object, Object, Object> determineTypeConverter(Set<Flag> var1);

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
            command.setValue(converter.boxValue(command.getValue()));
        }
        Object ret = this.invokeNextInterceptor(ctx, command);
        return converter.unboxValue(ret);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object ret;
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
        }
        if ((ret = this.invokeNextInterceptor(ctx, command)) != null) {
            if (command.isReturnEntry()) {
                InternalCacheEntry entry = (InternalCacheEntry)ret;
                Object returnValue = entry.getValue();
                if (command.getRemotelyFetchedValue() == null) {
                    returnValue = converter.unboxValue(entry.getValue());
                }
                return this.entryFactory.create(entry.getKey(), returnValue, entry.getMetadata(), entry.getLifespan(), entry.getMaxIdle());
            }
            if (command.getRemotelyFetchedValue() == null) {
                return converter.unboxValue(ret);
            }
            return ret;
        }
        return null;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        Object oldValue = command.getOldValue();
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
            command.setOldValue(converter.boxValue(oldValue));
            command.setNewValue(converter.boxValue(command.getNewValue()));
        }
        this.addVersionIfNeeded(command);
        Object ret = this.invokeNextInterceptor(ctx, command);
        if (oldValue != null && ret instanceof Boolean) {
            return ret;
        }
        return converter.unboxValue(ret);
    }

    private void addVersionIfNeeded(MetadataAwareCommand cmd) {
        Metadata metadata = cmd.getMetadata();
        if (metadata.version() == null) {
            Metadata newMetadata = metadata.builder().version(this.versionGenerator.generateNew()).build();
            cmd.setMetadata(newMetadata);
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        Object conditionalValue = command.getValue();
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
            command.setValue(converter.boxValue(conditionalValue));
        }
        Object ret = this.invokeNextInterceptor(ctx, command);
        if (conditionalValue != null && ret instanceof Boolean) {
            return ret;
        }
        return ctx.isOriginLocal() ? converter.unboxValue(ret) : ret;
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        Set set = (Set)super.visitEntrySetCommand(ctx, command);
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        HashSet<InternalCacheEntry> backingSet = new HashSet<InternalCacheEntry>(set.size());
        for (InternalCacheEntry entry : set) {
            Object key = converter.unboxKey(entry.getKey());
            Object value = converter.unboxValue(entry.getValue());
            InternalCacheEntry newEntry = this.entryFactory.create(key, value, entry.getMetadata(), entry.getLifespan(), entry.getMaxIdle());
            backingSet.add(newEntry);
        }
        return EntrySetCommand.createFilteredEntrySet(backingSet, ctx, this.timerService, this.entryFactory);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        Set keySet = (Set)super.visitKeySetCommand(ctx, command);
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        HashSet<Object> backingSet = new HashSet<Object>(keySet.size());
        for (Object key : keySet) {
            backingSet.add(converter.unboxKey(key));
        }
        return Immutables.immutableSetWrap(backingSet);
    }
}

