/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.io.FileChunkMapper;
import org.infinispan.io.GridFile;
import org.infinispan.io.ModularArithmetic;

public class GridInputStream
extends InputStream {
    private int index = 0;
    private int localIndex = 0;
    private byte[] currentBuffer = null;
    private int fSize;
    private boolean streamClosed = false;
    private final FileChunkMapper fileChunkMapper;
    private final int chunkSize;

    GridInputStream(GridFile file, Cache<String, byte[]> cache) {
        this.fileChunkMapper = new FileChunkMapper(file, cache);
        this.chunkSize = this.fileChunkMapper.getChunkSize();
        this.fSize = (int)file.length();
    }

    @Override
    public int read() throws IOException {
        this.assertOpen();
        if (this.isEndReached()) {
            return -1;
        }
        if (this.getBytesRemainingInChunk() == 0) {
            this.getChunk();
        }
        int retval = 0xFF & this.currentBuffer[this.localIndex++];
        ++this.index;
        return retval;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        this.assertOpen();
        int totalBytesRead = 0;
        while (length > 0) {
            int bytesRead = this.readFromChunk(bytes, offset, length);
            if (bytesRead == -1) {
                return totalBytesRead > 0 ? totalBytesRead : -1;
            }
            offset += bytesRead;
            length -= bytesRead;
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    private int readFromChunk(byte[] b, int off, int len) {
        if (this.isEndReached()) {
            return -1;
        }
        int remaining = this.getBytesRemainingInChunk();
        if (remaining == 0) {
            this.getChunk();
            remaining = this.getBytesRemainingInChunk();
        }
        int bytesToRead = Math.min(len, remaining);
        System.arraycopy(this.currentBuffer, this.localIndex, b, off, bytesToRead);
        this.localIndex += bytesToRead;
        this.index += bytesToRead;
        return bytesToRead;
    }

    @Override
    public long skip(long length) throws IOException {
        this.assertOpen();
        if (length <= 0L) {
            return 0L;
        }
        int bytesToSkip = Math.min((int)length, this.getBytesRemainingInStream());
        this.index += bytesToSkip;
        if (bytesToSkip <= this.getBytesRemainingInChunk()) {
            this.localIndex += bytesToSkip;
        } else {
            this.getChunk();
            this.localIndex = ModularArithmetic.mod(this.index, this.chunkSize);
        }
        return bytesToSkip;
    }

    @Override
    public int available() throws IOException {
        this.assertOpen();
        return this.getBytesRemainingInChunk();
    }

    @Override
    public void close() throws IOException {
        this.index = 0;
        this.localIndex = 0;
        this.streamClosed = true;
    }

    private boolean isEndReached() {
        return this.index == this.fSize;
    }

    private void assertOpen() throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream is closed");
        }
    }

    private int getBytesRemainingInChunk() {
        return this.currentBuffer == null ? 0 : this.currentBuffer.length - this.localIndex;
    }

    private int getBytesRemainingInStream() {
        return this.fSize - this.index;
    }

    private void getChunk() {
        this.currentBuffer = this.fileChunkMapper.fetchChunk(this.getChunkNumber());
        this.localIndex = 0;
    }

    private int getChunkNumber() {
        return this.index / this.chunkSize;
    }
}

