/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    BATCH_SIZE("batch-size"),
    CONNECTION_URL("connection-url"),
    CREATE_ON_START("create-on-start"),
    JNDI_URL("jndi-url"),
    DRIVER_CLASS("driver"),
    DROP_ON_EXIT("drop-on-exit"),
    FETCH_SIZE("fetch-size"),
    KEY_TO_STRING_MAPPER("key-to-string-mapper"),
    NAME("name"),
    PASSIVATION("passivation"),
    PASSWORD("password"),
    PREFIX("prefix"),
    TYPE("type"),
    USERNAME("username");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

