/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class SimpleToken
extends AuthToken {
    @Property
    private String auth_value = null;

    public SimpleToken() {
    }

    public SimpleToken(String authvalue) {
        this.auth_value = authvalue;
    }

    @Override
    public String getName() {
        return "org.jgroups.auth.SimpleToken";
    }

    public String getAuthValue() {
        return this.auth_value;
    }

    public void setAuthValue(String auth_value) {
        this.auth_value = auth_value;
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        if (token != null && token instanceof SimpleToken) {
            SimpleToken serverToken = (SimpleToken)token;
            if (this.auth_value != null && serverToken.auth_value != null && this.auth_value.equalsIgnoreCase(serverToken.auth_value)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("SimpleToken match");
                }
                return true;
            }
            return false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid AuthToken instance - wrong type or null");
        }
        return false;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SimpleToken writeTo()");
        }
        Bits.writeString(this.auth_value, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SimpleToken readFrom()");
        }
        this.auth_value = Bits.readString(in);
    }

    @Override
    public int size() {
        return Util.size(this.auth_value);
    }

    public String toString() {
        return "auth_value=" + this.auth_value;
    }
}

