/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth.sasl;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.auth.sasl.SaslContext;
import org.jgroups.protocols.SASL;
import org.jgroups.protocols.SaslHeader;

public class SaslClientContext
implements SaslContext {
    private static final byte[] EMPTY_CHALLENGE = new byte[0];
    SaslClient client;

    public SaslClientContext(String mech, Address local_addr, CallbackHandler callback_handler, Map<String, String> props) throws SaslException {
        this.client = Sasl.createSaslClient(new String[]{mech}, null, "jgroups", local_addr.toString(), props, callback_handler);
    }

    @Override
    public boolean isSuccessful() {
        return this.client.isComplete();
    }

    @Override
    public boolean needsWrapping() {
        if (this.client.isComplete()) {
            String qop = (String)this.client.getNegotiatedProperty("javax.security.sasl.qop");
            return qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"));
        }
        return false;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return this.client.wrap(outgoing, offset, len);
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return this.client.unwrap(incoming, offset, len);
    }

    @Override
    public Message nextMessage(Address address, SaslHeader header) throws SaslException {
        Message message = new Message(address).setFlag(Message.Flag.OOB);
        return this.addHeader(message, header.getPayload());
    }

    @Override
    public void dispose() {
        try {
            this.client.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    public Message addHeader(Message msg, byte[] payload) throws SaslException {
        byte[] response = payload == null ? (this.client.hasInitialResponse() ? this.client.evaluateChallenge(EMPTY_CHALLENGE) : EMPTY_CHALLENGE) : this.client.evaluateChallenge(payload);
        if (response != null) {
            return msg.putHeader(SASL.SASL_ID, new SaslHeader(SaslHeader.Type.RESPONSE, response));
        }
        return null;
    }
}

