/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Header;
import org.jgroups.ViewId;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class PingHeader
extends Header {
    public static final byte GET_MBRS_REQ = 1;
    public static final byte GET_MBRS_RSP = 2;
    public byte type = 0;
    public String cluster_name;
    public ViewId view_id;

    public PingHeader() {
    }

    public PingHeader(byte type) {
        this.type = type;
    }

    public PingHeader clusterName(String name) {
        this.cluster_name = name;
        return this;
    }

    public PingHeader viewId(ViewId view_id) {
        this.view_id = view_id;
        return this;
    }

    @Override
    public int size() {
        int retval = 2;
        if (this.cluster_name != null) {
            retval += this.cluster_name.length() + 2;
        }
        return retval += Util.size(this.view_id);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[PING: type=" + PingHeader.type2Str(this.type));
        if (this.cluster_name != null) {
            sb.append(", cluster=").append(this.cluster_name);
        }
        if (this.view_id != null) {
            sb.append(", view_id=").append(this.view_id);
        }
        sb.append(']');
        return sb.toString();
    }

    static String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "GET_MBRS_REQ";
            }
            case 2: {
                return "GET_MBRS_RSP";
            }
        }
        return "<unkown type (" + t + ")>";
    }

    @Override
    public void writeTo(DataOutput outstream) throws Exception {
        outstream.writeByte(this.type);
        Bits.writeString(this.cluster_name, outstream);
        Util.writeViewId(this.view_id, outstream);
    }

    @Override
    public void readFrom(DataInput instream) throws Exception {
        this.type = instream.readByte();
        this.cluster_name = Bits.readString(instream);
        this.view_id = Util.readViewId(instream);
    }
}

