/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.Bits;
import org.jgroups.util.Filter;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SeqnoList;
import org.jgroups.util.Table;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TimeService;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Reliable unicast layer")
public class UNICAST3
extends Protocol
implements AgeOutCache.Handler<Address> {
    protected static final long DEFAULT_FIRST_SEQNO = 1L;
    @Property(description="Max number of messages to be removed from a retransmit window. This property might get removed anytime, so don't use it !")
    protected int max_msg_batch_size = 500;
    @Property(description="Time (in milliseconds) after which an idle incoming or outgoing connection is closed. The connection will get re-established when used again. 0 disables connection reaping")
    protected long conn_expiry_timeout = 120000L;
    @Property(description="Time (in ms) until a connection marked to be closed will get removed. 0 disables this")
    protected long conn_close_timeout = 10000L;
    @Property(description="Number of rows of the matrix in the retransmission table (only for experts)", writable=false)
    protected int xmit_table_num_rows = 100;
    @Property(description="Number of elements of a row of the matrix in the retransmission table (only for experts). The capacity of the matrix is xmit_table_num_rows * xmit_table_msgs_per_row", writable=false)
    protected int xmit_table_msgs_per_row = 1000;
    @Property(description="Resize factor of the matrix in the retransmission table (only for experts)", writable=false)
    protected double xmit_table_resize_factor = 1.2;
    @Property(description="Number of milliseconds after which the matrix in the retransmission table is compacted (only for experts)", writable=false)
    protected long xmit_table_max_compaction_time = 600000L;
    protected long max_retransmit_time = 60000L;
    @Property(description="Interval (in milliseconds) at which messages in the send windows are resent")
    protected long xmit_interval = 500L;
    @Property(description="If true, trashes warnings about retransmission messages not found in the xmit_table (used for testing)")
    protected boolean log_not_found_msgs = true;
    @Property(description="Send an ack for a batch immediately instead of using a delayed ack", deprecatedMessage="replaced by ack_threshold")
    @Deprecated
    protected boolean ack_batches_immediately = true;
    @Property(description="Send an ack immediately when a batch of ack_threshold (or more) messages is received. Otherwise send delayed acks. If 1, ack single messages (similar to UNICAST)")
    protected int ack_threshold = 5;
    protected long num_msgs_sent = 0L;
    protected long num_msgs_received = 0L;
    protected long num_acks_sent = 0L;
    protected long num_acks_received = 0L;
    protected long num_xmits = 0L;
    @ManagedAttribute(description="Number of retransmit requests received")
    protected final AtomicLong xmit_reqs_received = new AtomicLong(0L);
    @ManagedAttribute(description="Number of retransmit requests sent")
    protected final AtomicLong xmit_reqs_sent = new AtomicLong(0L);
    @ManagedAttribute(description="Number of retransmit responses sent")
    protected final AtomicLong xmit_rsps_sent = new AtomicLong(0L);
    protected final ConcurrentMap<Address, SenderEntry> send_table = Util.createConcurrentMap();
    protected final ConcurrentMap<Address, ReceiverEntry> recv_table = Util.createConcurrentMap();
    protected final ReentrantLock recv_table_lock = new ReentrantLock();
    protected final Map<Address, Long> xmit_task_map = new HashMap<Address, Long>();
    protected Future<?> xmit_task;
    protected volatile List<Address> members = new ArrayList<Address>(11);
    protected Address local_addr;
    protected TimeScheduler timer;
    protected volatile boolean running = false;
    protected short last_conn_id;
    protected AgeOutCache<Address> cache;
    protected TimeService time_service;
    protected static final Message DUMMY_OOB_MSG = new Message(false).setFlag(Message.Flag.OOB);
    protected static final Filter<Message> drop_oob_msgs_filter = new Filter<Message>(){

        @Override
        public boolean accept(Message msg) {
            return msg != null && msg.hashCode() != DUMMY_OOB_MSG.hashCode();
        }
    };

    public void setMaxMessageBatchSize(int size) {
        if (size >= 1) {
            this.max_msg_batch_size = size;
        }
    }

    @ManagedAttribute
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getMembers() {
        return this.members.toString();
    }

    @ManagedAttribute(description="Returns the number of outgoing (send) connections")
    public int getNumSendConnections() {
        return this.send_table.size();
    }

    @ManagedAttribute(description="Returns the number of incoming (receive) connections")
    public int getNumReceiveConnections() {
        return this.recv_table.size();
    }

    @ManagedAttribute(description="Returns the total number of outgoing (send) and incoming (receive) connections")
    public int getNumConnections() {
        return this.getNumReceiveConnections() + this.getNumSendConnections();
    }

    @ManagedOperation
    public String printConnections() {
        StringBuilder sb = new StringBuilder();
        if (!this.send_table.isEmpty()) {
            sb.append("\nsend connections:\n");
            for (Map.Entry entry : this.send_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        if (!this.recv_table.isEmpty()) {
            sb.append("\nreceive connections:\n");
            for (Map.Entry entry : this.recv_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    @ManagedAttribute
    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    @ManagedAttribute
    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    @ManagedAttribute
    public long getNumAcksSent() {
        return this.num_acks_sent;
    }

    @ManagedAttribute
    public long getNumAcksReceived() {
        return this.num_acks_received;
    }

    @ManagedAttribute
    public long getNumXmits() {
        return this.num_xmits;
    }

    public long getMaxRetransmitTime() {
        return this.max_retransmit_time;
    }

    @Property(description="Max number of milliseconds we try to retransmit a message to any given member. After that, the connection is removed. Any new connection to that member will start with seqno #1 again. 0 disables this")
    public void setMaxRetransmitTime(long max_retransmit_time) {
        this.max_retransmit_time = max_retransmit_time;
        if (this.cache != null && max_retransmit_time > 0L) {
            this.cache.setTimeout(max_retransmit_time);
        }
    }

    @ManagedAttribute(description="Is the retransmit task running")
    public boolean isXmitTaskRunning() {
        return this.xmit_task != null && !this.xmit_task.isDone();
    }

    @ManagedAttribute
    public int getAgeOutCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    @ManagedOperation
    public String printAgeOutCache() {
        return this.cache != null ? this.cache.toString() : "n/a";
    }

    public AgeOutCache<Address> getAgeOutCache() {
        return this.cache;
    }

    public boolean hasSendConnectionTo(Address dest) {
        SenderEntry entry = (SenderEntry)this.send_table.get(dest);
        return entry != null && entry.state() == State.OPEN;
    }

    @ManagedAttribute
    public int getNumUnackedMessages() {
        int num = 0;
        for (SenderEntry entry : this.send_table.values()) {
            if (entry.sent_msgs == null) continue;
            num += entry.sent_msgs.size();
        }
        return num;
    }

    @ManagedAttribute
    public int getNumberOfMessagesInReceiveWindows() {
        int num = 0;
        for (ReceiverEntry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            num += entry.received_msgs.size();
        }
        return num;
    }

    @ManagedAttribute(description="Total number of undelivered messages in all receive windows")
    public long getXmitTableUndeliveredMessages() {
        long retval = 0L;
        for (ReceiverEntry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            retval += (long)entry.received_msgs.size();
        }
        return retval;
    }

    @ManagedAttribute(description="Total number of missing messages in all receive windows")
    public long getXmitTableMissingMessages() {
        long retval = 0L;
        for (ReceiverEntry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            retval += (long)entry.received_msgs.getNumMissing();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of compactions in all (receive and send) windows")
    public int getXmitTableNumCompactions() {
        int retval = 0;
        for (Entry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            retval += entry.received_msgs.getNumCompactions();
        }
        for (Entry entry : this.send_table.values()) {
            if (((SenderEntry)entry).sent_msgs == null) continue;
            retval += ((SenderEntry)entry).sent_msgs.getNumCompactions();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of moves in all (receive and send) windows")
    public int getXmitTableNumMoves() {
        int retval = 0;
        for (Entry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            retval += entry.received_msgs.getNumMoves();
        }
        for (Entry entry : this.send_table.values()) {
            if (((SenderEntry)entry).sent_msgs == null) continue;
            retval += ((SenderEntry)entry).sent_msgs.getNumMoves();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of resizes in all (receive and send) windows")
    public int getXmitTableNumResizes() {
        int retval = 0;
        for (Entry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            retval += entry.received_msgs.getNumResizes();
        }
        for (Entry entry : this.send_table.values()) {
            if (((SenderEntry)entry).sent_msgs == null) continue;
            retval += ((SenderEntry)entry).sent_msgs.getNumResizes();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of purges in all (receive and send) windows")
    public int getXmitTableNumPurges() {
        int retval = 0;
        for (Entry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            retval += entry.received_msgs.getNumPurges();
        }
        for (Entry entry : this.send_table.values()) {
            if (((SenderEntry)entry).sent_msgs == null) continue;
            retval += ((SenderEntry)entry).sent_msgs.getNumPurges();
        }
        return retval;
    }

    @ManagedOperation(description="Prints the contents of the receive windows for all members")
    public String printReceiveWindowMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.recv_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Table<Message> buf = ((ReceiverEntry)entry.getValue()).received_msgs;
            ret.append(addr).append(": ").append(buf.toString()).append('\n');
        }
        return ret.toString();
    }

    @ManagedOperation(description="Prints the contents of the send windows for all members")
    public String printSendWindowMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.send_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Table<Message> buf = ((SenderEntry)entry.getValue()).sent_msgs;
            ret.append(addr).append(": ").append(buf.toString()).append('\n');
        }
        return ret.toString();
    }

    @Override
    public void resetStats() {
        this.num_acks_received = 0L;
        this.num_acks_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_xmits = 0L;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> m = super.dumpStats();
        m.put("num_unacked_msgs", this.getNumUnackedMessages());
        m.put("num_msgs_in_recv_windows", this.getNumberOfMessagesInReceiveWindows());
        return m;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.time_service = this.getTransport().getTimeService();
        if (this.time_service == null) {
            throw new IllegalStateException("time service from transport is null");
        }
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.max_retransmit_time > 0L) {
            this.cache = new AgeOutCache(this.timer, this.max_retransmit_time, this);
        }
        this.running = true;
        this.startRetransmitTask();
    }

    @Override
    public void stop() {
        this.sendPendingAcks();
        this.running = false;
        this.stopRetransmitTask();
        this.xmit_task_map.clear();
        this.removeAllConnections();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Header hdr;
                Message msg = (Message)evt.getArg();
                if (msg.getDest() == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY) || (hdr = (Header)msg.getHeader(this.id)) == null) break;
                Address sender = msg.getSrc();
                switch (hdr.type) {
                    case 0: {
                        this.handleDataReceived(sender, hdr.seqno, hdr.conn_id, hdr.first, msg, evt);
                        break;
                    }
                    default: {
                        this.handleUpEvent(sender, msg, hdr);
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    protected void handleUpEvent(Address sender, Message msg, Header hdr) {
        switch (hdr.type) {
            case 0: {
                throw new IllegalStateException("header of type DATA is not supposed to be handled by this method");
            }
            case 1: {
                this.handleAckReceived(sender, hdr.seqno, hdr.conn_id);
                break;
            }
            case 2: {
                this.handleResendingOfFirstMessage(sender);
                break;
            }
            case 3: {
                this.handleXmitRequest(sender, (SeqnoList)msg.getObject());
                break;
            }
            case 4: {
                this.log.trace(this.local_addr + "%s <-- CLOSE(%s: conn-id=%s)", this.local_addr, sender, hdr.conn_id);
                ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
                if (entry == null || entry.connId() != hdr.conn_id) break;
                this.recv_table.remove(sender, entry);
                this.log.trace("%s: removed receive connection for %s", this.local_addr, sender);
                break;
            }
            default: {
                this.log.error(Util.getMessage("TypeNotKnown"), this.local_addr, hdr.type);
            }
        }
    }

    @Override
    public void up(MessageBatch batch) {
        if (batch.dest() == null) {
            this.up_prot.up(batch);
            return;
        }
        int size = batch.size();
        LinkedHashMap<Short, ArrayList<Tuple<Long, Message>>> msgs = new LinkedHashMap<Short, ArrayList<Tuple<Long, Message>>>();
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(batch.sender());
        for (Message msg : batch) {
            Header hdr;
            if (msg == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY) || (hdr = (Header)msg.getHeader(this.id)) == null) continue;
            batch.remove(msg);
            if (hdr.type != 0) {
                try {
                    this.handleUpEvent(msg.getSrc(), msg, hdr);
                }
                catch (Throwable t) {
                    this.log.error(Util.getMessage("FailedHandlingEvent"), this.local_addr, t);
                }
                continue;
            }
            ArrayList<Tuple<Long, Message>> list = (ArrayList<Tuple<Long, Message>>)msgs.get(hdr.conn_id);
            if (list == null) {
                list = new ArrayList<Tuple<Long, Message>>(size);
                msgs.put(hdr.conn_id, list);
            }
            list.add(new Tuple<Long, Message>(hdr.seqno(), msg));
            if (!hdr.first) continue;
            entry = this.getReceiverEntry(batch.sender(), hdr.seqno(), hdr.first, hdr.connId());
        }
        if (!msgs.isEmpty()) {
            if (entry == null) {
                this.sendRequestForFirstSeqno(batch.sender());
            } else {
                List list;
                if (msgs.keySet().retainAll(Arrays.asList(entry.connId()))) {
                    this.sendRequestForFirstSeqno(batch.sender());
                }
                if ((list = (List)msgs.get(entry.connId())) != null && !list.isEmpty()) {
                    this.handleBatchReceived(entry, batch.sender(), list, batch.mode() == MessageBatch.Mode.OOB);
                }
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY)) break;
                if (!this.running) {
                    this.log.trace("%s: discarded message as start() has not yet been called, message: %s", this.local_addr, msg);
                    return null;
                }
                SenderEntry entry = (SenderEntry)this.send_table.get(dst);
                if (entry == null || entry.state() == State.CLOSED) {
                    SenderEntry existing;
                    if (entry != null) {
                        this.send_table.remove(dst, entry);
                    }
                    if ((existing = this.send_table.putIfAbsent(dst, entry = new SenderEntry(this.getNewConnectionId()))) != null) {
                        entry = existing;
                    } else {
                        this.log.trace("%s: created sender window for %s (conn-id=%s)", this.local_addr, dst, entry.connId());
                        if (this.cache != null && !this.members.contains(dst)) {
                            this.cache.add(dst);
                        }
                    }
                }
                if (entry.state() == State.CLOSING) {
                    entry.state(State.OPEN);
                }
                short send_conn_id = entry.connId();
                long seqno = entry.sent_msgs_seqno.getAndIncrement();
                long sleep = 10L;
                while (true) {
                    try {
                        msg.putHeader(this.id, Header.createDataHeader(seqno, send_conn_id, seqno == 1L));
                        entry.sent_msgs.add(seqno, msg);
                        if (this.conn_expiry_timeout <= 0L) break;
                        entry.update();
                    }
                    catch (Throwable t) {
                        if (!this.running) continue;
                        Util.sleep(sleep);
                        sleep = Math.min(5000L, sleep * 2L);
                        if (this.running) continue;
                    }
                    break;
                }
                if (this.log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.local_addr).append(" --> DATA(").append(dst).append(": #").append(seqno).append(", conn_id=").append(send_conn_id);
                    if (seqno == 1L) {
                        sb.append(", first");
                    }
                    sb.append(')');
                    this.log.trace(sb);
                }
                ++this.num_msgs_sent;
                return this.down_prot.down(evt);
            }
            case 6: {
                View view = (View)evt.getArg();
                List<Address> new_members = view.getMembers();
                HashSet non_members = new HashSet(this.send_table.keySet());
                non_members.addAll(this.recv_table.keySet());
                this.members = new_members;
                non_members.removeAll(new_members);
                if (this.cache != null) {
                    this.cache.removeAll(new_members);
                }
                if (!non_members.isEmpty()) {
                    this.log.trace("%s: closing connections of non members %s", this.local_addr, non_members);
                    for (Address non_mbr : non_members) {
                        this.closeConnection(non_mbr);
                    }
                }
                if (!new_members.isEmpty()) {
                    for (Address mbr : new_members) {
                        Entry e = (Entry)this.send_table.get(mbr);
                        if (e != null && e.state() == State.CLOSING) {
                            e.state(State.OPEN);
                        }
                        if ((e = (Entry)this.recv_table.get(mbr)) == null || e.state() != State.CLOSING) continue;
                        e.state(State.OPEN);
                    }
                }
                this.xmit_task_map.keySet().retainAll(new_members);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    public void closeConnection(Address mbr) {
        this.closeSendConnection(mbr);
        this.closeReceiveConnection(mbr);
    }

    public void closeSendConnection(Address mbr) {
        SenderEntry entry = (SenderEntry)this.send_table.get(mbr);
        if (entry != null) {
            entry.state(State.CLOSING);
        }
    }

    public void closeReceiveConnection(Address mbr) {
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(mbr);
        if (entry != null) {
            entry.state(State.CLOSING);
        }
    }

    protected void removeSendConnection(Address mbr) {
        SenderEntry entry = (SenderEntry)this.send_table.remove(mbr);
        if (entry != null) {
            entry.state(State.CLOSED);
            this.sendClose(mbr, entry.connId());
        }
    }

    protected void removeReceiveConnection(Address mbr) {
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.remove(mbr);
        if (entry != null) {
            entry.state(State.CLOSED);
        }
    }

    @ManagedOperation(description="Trashes all connections to other nodes. This is only used for testing")
    public void removeAllConnections() {
        this.send_table.clear();
        this.recv_table.clear();
    }

    protected void retransmit(SeqnoList missing, Address sender) {
        Message xmit_msg = new Message(sender, missing).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.id, Header.createXmitReqHeader());
        this.log.trace("%s: sending XMIT_REQ (%s) to %s", this.local_addr, missing, sender);
        this.down_prot.down(new Event(1, xmit_msg));
        this.xmit_reqs_sent.addAndGet(missing.size());
    }

    protected void retransmit(Message msg) {
        if (this.log.isTraceEnabled()) {
            Header hdr = (Header)msg.getHeader(this.id);
            long seqno = hdr != null ? hdr.seqno : -1L;
            this.log.trace("%s --> XMIT(%s: #%d)", this.local_addr, msg.getDest(), seqno);
        }
        this.down_prot.down(new Event(1, msg));
        ++this.num_xmits;
    }

    @Override
    public void expired(Address key) {
        if (key != null) {
            this.log.debug("%s: removing connection to %s because it expired", this.local_addr, key);
            this.closeConnection(key);
        }
    }

    protected void handleDataReceived(final Address sender, long seqno, short conn_id, boolean first, Message msg, Event evt) {
        ReceiverEntry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s <-- DATA(%s: #%d, conn_id=%d%s)", this.local_addr, sender, seqno, conn_id, first ? ", first" : "");
        }
        if ((entry = this.getReceiverEntry(sender, seqno, first, conn_id)) == null) {
            return;
        }
        if (this.conn_expiry_timeout > 0L) {
            entry.update();
        }
        if (entry.state() == State.CLOSING) {
            entry.state(State.OPEN);
        }
        boolean oob = msg.isFlagSet(Message.Flag.OOB);
        final Table<Message> win = entry.received_msgs;
        boolean added = win.add(seqno, oob ? DUMMY_OOB_MSG : msg);
        ++this.num_msgs_received;
        if (this.ack_threshold <= 1) {
            this.sendAck(sender, win.getHighestDeliverable(), entry.connId());
        } else {
            entry.sendAck(true);
        }
        if (oob && added) {
            this.deliverMessage(evt, sender, seqno);
        }
        if (oob && msg.isFlagSet(Message.Flag.INTERNAL)) {
            final AtomicBoolean processing = win.getProcessing();
            if (!win.isEmpty() && !processing.get() && seqno < win.getHighestReceived()) {
                Executor pool = this.getTransport().getDefaultThreadPool();
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (processing.compareAndSet(false, true)) {
                            UNICAST3.this.removeAndDeliver(processing, win, sender);
                        }
                    }
                });
            }
            return;
        }
        AtomicBoolean processing = win.getProcessing();
        if (processing.compareAndSet(false, true)) {
            this.removeAndDeliver(processing, win, sender);
        }
    }

    protected void handleBatchReceived(ReceiverEntry entry, Address sender, List<Tuple<Long, Message>> msgs, boolean oob) {
        AtomicBoolean processing;
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s <-- DATA(%s: %s)", this.local_addr, sender, this.printMessageList(msgs));
        }
        int batch_size = msgs.size();
        Table<Message> win = entry.received_msgs;
        this.num_msgs_received += (long)batch_size;
        boolean added = win.add(msgs, oob, oob ? DUMMY_OOB_MSG : null);
        if (this.conn_expiry_timeout > 0L) {
            entry.update();
        }
        if (entry.state() == State.CLOSING) {
            entry.state(State.OPEN);
        }
        if (batch_size >= this.ack_threshold) {
            this.sendAck(sender, win.getHighestDeliverable(), entry.connId());
        } else {
            entry.sendAck(true);
        }
        if (added && oob) {
            MessageBatch oob_batch = new MessageBatch(this.local_addr, sender, null, false, MessageBatch.Mode.OOB, msgs.size());
            for (Tuple tuple : msgs) {
                oob_batch.add((Message)tuple.getVal2());
            }
            this.deliverBatch(oob_batch);
        }
        if ((processing = win.getProcessing()).compareAndSet(false, true)) {
            this.removeAndDeliver(processing, win, sender);
        }
    }

    protected void removeAndDeliver(AtomicBoolean processing, Table<Message> win, Address sender) {
        boolean released_processing = false;
        try {
            while (true) {
                List<Message> list;
                if ((list = win.removeMany(processing, true, this.max_msg_batch_size, drop_oob_msgs_filter)) == null) {
                    released_processing = true;
                    return;
                }
                this.deliverBatch(new MessageBatch(this.local_addr, sender, null, false, list));
            }
        }
        finally {
            if (!released_processing) {
                processing.set(false);
            }
        }
    }

    protected String printMessageList(List<Tuple<Long, Message>> list) {
        Header hdr;
        Message second;
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        Message first = size > 0 ? list.get(0).getVal2() : null;
        Message message = second = size > 1 ? list.get(size - 1).getVal2() : first;
        if (first != null && (hdr = (Header)first.getHeader(this.id)) != null) {
            sb.append("#" + hdr.seqno);
        }
        if (second != null && (hdr = (Header)second.getHeader(this.id)) != null) {
            sb.append(" - #" + hdr.seqno);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReceiverEntry getReceiverEntry(Address sender, long seqno, boolean first, short conn_id) {
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
        if (entry != null && entry.connId() == conn_id) {
            return entry;
        }
        this.recv_table_lock.lock();
        try {
            entry = (ReceiverEntry)this.recv_table.get(sender);
            if (first) {
                if (entry == null) {
                    entry = this.createReceiverEntry(sender, seqno, conn_id);
                } else if (conn_id != entry.connId()) {
                    this.log.trace("%s: conn_id=%d != %d; resetting receiver window", this.local_addr, conn_id, entry.connId());
                    this.recv_table.remove(sender);
                    entry = this.createReceiverEntry(sender, seqno, conn_id);
                }
            } else if (entry == null || entry.connId() != conn_id) {
                this.recv_table_lock.unlock();
                this.sendRequestForFirstSeqno(sender);
                ReceiverEntry receiverEntry = null;
                return receiverEntry;
            }
            ReceiverEntry receiverEntry = entry;
            return receiverEntry;
        }
        finally {
            if (this.recv_table_lock.isHeldByCurrentThread()) {
                this.recv_table_lock.unlock();
            }
        }
    }

    protected ReceiverEntry createReceiverEntry(Address sender, long seqno, short conn_id) {
        Table<Message> table = new Table<Message>(this.xmit_table_num_rows, this.xmit_table_msgs_per_row, seqno - 1L, this.xmit_table_resize_factor, this.xmit_table_max_compaction_time);
        ReceiverEntry entry = new ReceiverEntry(table, conn_id);
        ReceiverEntry entry2 = this.recv_table.putIfAbsent(sender, entry);
        if (entry2 != null) {
            return entry2;
        }
        this.log.trace("%s: created receiver window for %s at seqno=#%d for conn-id=%d", this.local_addr, sender, seqno, conn_id);
        return entry;
    }

    protected void handleAckReceived(Address sender, long seqno, short conn_id) {
        Table<Message> win;
        SenderEntry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s <-- ACK(%s: #%d, conn-id=%d)", this.local_addr, sender, seqno, conn_id);
        }
        if ((entry = (SenderEntry)this.send_table.get(sender)) != null && entry.connId() != conn_id) {
            this.log.trace("%s: my conn_id (%d) != received conn_id (%d); discarding ACK", this.local_addr, entry.connId(), conn_id);
            return;
        }
        Table<Message> table = win = entry != null ? entry.sent_msgs : null;
        if (win != null) {
            win.purge(seqno, true);
            ++this.num_acks_received;
        }
    }

    protected void handleResendingOfFirstMessage(Address sender) {
        Table<Message> win;
        this.log.trace("%s <-- SEND_FIRST_SEQNO(%s)", this.local_addr, sender);
        SenderEntry entry = (SenderEntry)this.send_table.get(sender);
        Table<Message> table = win = entry != null ? entry.sent_msgs : null;
        if (win == null) {
            this.log.warn(Util.getMessage("SenderNotFound"), this.local_addr, sender);
            return;
        }
        Message rsp = win.get(win.getLow() + 1L);
        if (rsp != null) {
            Message copy = rsp.copy();
            Header hdr = (Header)copy.getHeader(this.id);
            Header newhdr = hdr.copy();
            newhdr.first = true;
            copy.putHeader(this.id, newhdr);
            this.down_prot.down(new Event(1, copy));
        }
    }

    protected void handleXmitRequest(Address sender, SeqnoList missing) {
        Table<Message> win;
        this.log.trace("%s <-- XMIT(%s: #%s)", this.local_addr, sender, missing);
        SenderEntry entry = (SenderEntry)this.send_table.get(sender);
        this.xmit_reqs_received.addAndGet(missing.size());
        Table<Message> table = win = entry != null ? entry.sent_msgs : null;
        if (win != null) {
            for (long seqno : missing) {
                Message msg = win.get(seqno);
                if (msg == null) {
                    if (!this.log.isWarnEnabled() || !this.log_not_found_msgs || this.local_addr.equals(sender) || seqno <= win.getLow()) continue;
                    this.log.warn(Util.getMessage("MessageNotFound"), this.local_addr, sender, seqno);
                    continue;
                }
                this.down_prot.down(new Event(1, msg));
                this.xmit_rsps_sent.incrementAndGet();
            }
        }
    }

    protected void deliverMessage(Event evt, Address sender, long seqno) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: delivering %s#%s", this.local_addr, sender, seqno);
        }
        try {
            this.up_prot.up(evt);
        }
        catch (Throwable t) {
            Message msg = (Message)evt.getArg();
            this.log.error(Util.getMessage("FailedToDeliverMsg"), this.local_addr, msg.isFlagSet(Message.Flag.OOB) ? "OOB message" : "message", msg, t);
        }
    }

    protected void deliverBatch(MessageBatch batch) {
        try {
            if (batch.isEmpty()) {
                return;
            }
            if (this.log.isTraceEnabled()) {
                Message first = batch.first();
                Message last = batch.last();
                StringBuilder sb = new StringBuilder(this.local_addr + ": delivering");
                if (first != null && last != null) {
                    Header hdr1 = (Header)first.getHeader(this.id);
                    Header hdr2 = (Header)last.getHeader(this.id);
                    sb.append(" #").append(hdr1.seqno).append(" - #").append(hdr2.seqno);
                }
                sb.append(" (" + batch.size()).append(" messages)");
                this.log.trace(sb);
            }
            this.up_prot.up(batch);
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedToDeliverMsg"), this.local_addr, "batch", batch, t);
        }
    }

    protected long getTimestamp() {
        return this.time_service.timestamp();
    }

    protected void startRetransmitTask() {
        if (this.xmit_task == null || this.xmit_task.isDone()) {
            this.xmit_task = this.timer.scheduleWithFixedDelay(new RetransmitTask(), 0L, this.xmit_interval, TimeUnit.MILLISECONDS);
        }
    }

    protected void stopRetransmitTask() {
        if (this.xmit_task != null) {
            this.xmit_task.cancel(true);
            this.xmit_task = null;
        }
    }

    protected void sendAck(Address dst, long seqno, short conn_id) {
        if (!this.running) {
            return;
        }
        Message ack = new Message(dst).setFlag(Message.Flag.INTERNAL).putHeader(this.id, Header.createAckHeader(seqno, conn_id));
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s --> ACK(%s: #%d)", this.local_addr, dst, seqno);
        }
        try {
            this.down_prot.down(new Event(1, ack));
            ++this.num_acks_sent;
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedSendingAck"), this.local_addr, seqno, dst, t);
        }
    }

    protected synchronized short getNewConnectionId() {
        short retval = this.last_conn_id;
        this.last_conn_id = this.last_conn_id >= Short.MAX_VALUE || this.last_conn_id < 0 ? (short)0 : (short)(this.last_conn_id + 1);
        return retval;
    }

    protected void sendRequestForFirstSeqno(Address dest) {
        Message msg = new Message(dest).setFlag(Message.Flag.OOB).putHeader(this.id, Header.createSendFirstSeqnoHeader());
        this.log.trace("%s --> SEND_FIRST_SEQNO(%s)", this.local_addr, dest);
        this.down_prot.down(new Event(1, msg));
    }

    public void sendClose(Address dest, short conn_id) {
        Message msg = new Message(dest).setFlag(Message.Flag.INTERNAL).putHeader(this.id, Header.createCloseHeader(conn_id));
        this.log.trace("%s --> CLOSE(%s, conn-id=%d)", this.local_addr, dest, conn_id);
        this.down_prot.down(new Event(1, msg));
    }

    @ManagedOperation(description="Closes connections that have been idle for more than conn_expiry_timeout ms")
    public void closeIdleConnections() {
        long age;
        Entry val;
        for (Map.Entry entry : this.send_table.entrySet()) {
            val = (SenderEntry)entry.getValue();
            if (val.state() != State.OPEN || (age = val.age()) < this.conn_expiry_timeout) continue;
            this.log.debug("%s: closing expired connection for %s (%d ms old) in send_table", this.local_addr, entry.getKey(), age);
            this.closeSendConnection((Address)entry.getKey());
        }
        for (Map.Entry entry : this.recv_table.entrySet()) {
            val = (ReceiverEntry)entry.getValue();
            if (val.state() != State.OPEN || (age = val.age()) < this.conn_expiry_timeout) continue;
            this.log.debug("%s: closing expired connection for %s (%d ms old) in recv_table", this.local_addr, entry.getKey(), age);
            this.closeReceiveConnection((Address)entry.getKey());
        }
    }

    @ManagedOperation(description="Removes connections that have been closed for more than conn_close_timeout ms")
    public int removeExpiredConnections() {
        long age;
        Entry val;
        int num_removed = 0;
        for (Map.Entry entry : this.send_table.entrySet()) {
            val = (SenderEntry)entry.getValue();
            if (val.state() == State.OPEN || (age = val.age()) < this.conn_close_timeout) continue;
            this.log.debug("%s: removing expired connection for %s (%d ms old) from send_table", this.local_addr, entry.getKey(), age);
            this.removeSendConnection((Address)entry.getKey());
            ++num_removed;
        }
        for (Map.Entry entry : this.recv_table.entrySet()) {
            val = (ReceiverEntry)entry.getValue();
            if (val.state() == State.OPEN || (age = val.age()) < this.conn_close_timeout) continue;
            this.log.debug("%s: removing expired connection for %s (%d ms old) from recv_table", this.local_addr, entry.getKey(), age);
            this.removeReceiveConnection((Address)entry.getKey());
            ++num_removed;
        }
        return num_removed;
    }

    @ManagedOperation(description="Triggers the retransmission task")
    public void triggerXmit() {
        for (Map.Entry entry : this.recv_table.entrySet()) {
            SeqnoList missing;
            Table<Message> win;
            Address target = (Address)entry.getKey();
            ReceiverEntry val = (ReceiverEntry)entry.getValue();
            Table<Message> table = win = val != null ? val.received_msgs : null;
            if (win != null && val.sendAck()) {
                this.sendAck(target, win.getHighestDeliverable(), val.connId());
            }
            if (win != null && win.getNumMissing() > 0 && (missing = win.getMissing()) != null) {
                long highest = missing.getLast();
                Long prev_seqno = this.xmit_task_map.get(target);
                if (prev_seqno == null) {
                    this.xmit_task_map.put(target, highest);
                    continue;
                }
                missing.removeHigherThan(prev_seqno);
                if (highest > prev_seqno) {
                    this.xmit_task_map.put(target, highest);
                }
                if (missing.size() <= 0) continue;
                this.retransmit(missing, target);
                continue;
            }
            if (this.xmit_task_map.isEmpty()) continue;
            this.xmit_task_map.remove(target);
        }
        for (SenderEntry val : this.send_table.values()) {
            long highest_sent;
            Table<Message> win = val != null ? val.sent_msgs : null;
            if (win == null) continue;
            long highest_acked = win.getHighestDelivered();
            if (highest_acked < (highest_sent = win.getHighestReceived()) && val.watermark[0] == highest_acked && val.watermark[1] == highest_sent) {
                Message highest_sent_msg = win.get(highest_sent);
                if (highest_sent_msg == null) continue;
                this.retransmit(highest_sent_msg);
                continue;
            }
            val.watermark(highest_acked, highest_sent);
        }
        if (this.conn_expiry_timeout > 0L) {
            this.closeIdleConnections();
        }
        if (this.conn_close_timeout > 0L) {
            this.removeExpiredConnections();
        }
    }

    protected void sendPendingAcks() {
        for (Map.Entry entry : this.recv_table.entrySet()) {
            Address target = (Address)entry.getKey();
            ReceiverEntry val = (ReceiverEntry)entry.getValue();
            Table<Message> win = val != null ? val.received_msgs : null;
            if (win == null || !val.sendAck()) continue;
            this.sendAck(target, win.getHighestDeliverable(), val.connId());
        }
    }

    protected class RetransmitTask
    implements Runnable {
        protected RetransmitTask() {
        }

        @Override
        public void run() {
            UNICAST3.this.triggerXmit();
        }

        public String toString() {
            return UNICAST3.class.getSimpleName() + ": RetransmitTask (interval=" + UNICAST3.this.xmit_interval + " ms)";
        }
    }

    protected final class ReceiverEntry
    extends Entry {
        protected final Table<Message> received_msgs;
        protected volatile boolean send_ack;

        public ReceiverEntry(Table<Message> received_msgs, short recv_conn_id) {
            super(recv_conn_id);
            this.received_msgs = received_msgs;
        }

        ReceiverEntry sendAck(boolean flag) {
            this.send_ack = flag;
            return this;
        }

        boolean sendAck() {
            boolean retval = this.send_ack;
            this.send_ack = false;
            return retval;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.received_msgs != null) {
                sb.append(this.received_msgs).append(", ");
            }
            sb.append("recv_conn_id=" + this.conn_id);
            sb.append(" (" + this.age() / 1000L + " secs old) - " + (Object)((Object)this.state));
            if (this.send_ack) {
                sb.append(" [ack pending]");
            }
            return sb.toString();
        }
    }

    protected final class SenderEntry
    extends Entry {
        final Table<Message> sent_msgs;
        final AtomicLong sent_msgs_seqno;
        protected final long[] watermark;

        public SenderEntry(short send_conn_id) {
            super(send_conn_id);
            this.sent_msgs_seqno = new AtomicLong(1L);
            this.watermark = new long[]{0L, 0L};
            this.sent_msgs = new Table(UNICAST3.this.xmit_table_num_rows, UNICAST3.this.xmit_table_msgs_per_row, 0L, UNICAST3.this.xmit_table_resize_factor, UNICAST3.this.xmit_table_max_compaction_time);
        }

        long[] watermark() {
            return this.watermark;
        }

        SenderEntry watermark(long ha, long hs) {
            this.watermark[0] = ha;
            this.watermark[1] = hs;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.sent_msgs != null) {
                sb.append(this.sent_msgs).append(", ");
            }
            sb.append("send_conn_id=" + this.conn_id).append(" (" + this.age() / 1000L + " secs old) - " + (Object)((Object)this.state));
            return sb.toString();
        }
    }

    protected abstract class Entry {
        final short conn_id;
        protected final AtomicLong timestamp = new AtomicLong(0L);
        protected volatile State state = State.OPEN;

        protected Entry(short conn_id) {
            this.conn_id = conn_id;
            this.update();
        }

        short connId() {
            return this.conn_id;
        }

        void update() {
            this.timestamp.set(UNICAST3.this.getTimestamp());
        }

        long age() {
            return UNICAST3.this.getTimestamp() - this.timestamp.longValue();
        }

        State state() {
            return this.state;
        }

        Entry state(State state) {
            if (this.state != state) {
                this.state = state;
                this.update();
            }
            return this;
        }
    }

    public static class Header
    extends org.jgroups.Header {
        public static final byte DATA = 0;
        public static final byte ACK = 1;
        public static final byte SEND_FIRST_SEQNO = 2;
        public static final byte XMIT_REQ = 3;
        public static final byte CLOSE = 4;
        byte type;
        long seqno;
        short conn_id;
        boolean first;

        public Header() {
        }

        protected Header(byte type) {
            this.type = type;
        }

        protected Header(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        protected Header(byte type, long seqno, short conn_id, boolean first) {
            this.type = type;
            this.seqno = seqno;
            this.conn_id = conn_id;
            this.first = first;
        }

        public static Header createDataHeader(long seqno, short conn_id, boolean first) {
            return new Header(0, seqno, conn_id, first);
        }

        public static Header createAckHeader(long seqno, short conn_id) {
            return new Header(1, seqno, conn_id, false);
        }

        public static Header createSendFirstSeqnoHeader() {
            return new Header(2);
        }

        public static Header createXmitReqHeader() {
            return new Header(3);
        }

        public static Header createCloseHeader(short conn_id) {
            return new Header(4, 0L, conn_id, false);
        }

        public long seqno() {
            return this.seqno;
        }

        public short connId() {
            return this.conn_id;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Header.type2Str(this.type)).append(", seqno=").append(this.seqno);
            if (this.conn_id != 0) {
                sb.append(", conn_id=").append(this.conn_id);
            }
            if (this.first) {
                sb.append(", first");
            }
            return sb.toString();
        }

        public static String type2Str(byte t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "ACK";
                }
                case 2: {
                    return "SEND_FIRST_SEQNO";
                }
                case 3: {
                    return "XMIT_REQ";
                }
                case 4: {
                    return "CLOSE";
                }
            }
            return "<unknown>";
        }

        @Override
        public final int size() {
            int retval = 1;
            switch (this.type) {
                case 0: {
                    retval += Bits.size(this.seqno) + 2 + 1;
                    break;
                }
                case 1: {
                    retval += Bits.size(this.seqno) + 2;
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    retval += 2;
                }
            }
            return retval;
        }

        public Header copy() {
            return new Header(this.type, this.seqno, this.conn_id, this.first);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            switch (this.type) {
                case 0: {
                    Bits.writeLong(this.seqno, out);
                    out.writeShort(this.conn_id);
                    out.writeBoolean(this.first);
                    break;
                }
                case 1: {
                    Bits.writeLong(this.seqno, out);
                    out.writeShort(this.conn_id);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    out.writeShort(this.conn_id);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            switch (this.type) {
                case 0: {
                    this.seqno = Bits.readLong(in);
                    this.conn_id = in.readShort();
                    this.first = in.readBoolean();
                    break;
                }
                case 1: {
                    this.seqno = Bits.readLong(in);
                    this.conn_id = in.readShort();
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    this.conn_id = in.readShort();
                }
            }
        }
    }

    protected static enum State {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

