/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractTransportConfigurationChildBuilder;
import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;

public class RecoveryConfigurationBuilder
extends AbstractTransportConfigurationChildBuilder
implements Builder<RecoveryConfiguration> {
    boolean enabled = true;
    private String recoveryInfoCacheName = "__recoveryInfoCacheName__";

    RecoveryConfigurationBuilder(TransactionConfigurationBuilder builder) {
        super(builder);
    }

    public RecoveryConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public RecoveryConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public RecoveryConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RecoveryConfigurationBuilder recoveryInfoCacheName(String recoveryInfoName) {
        this.recoveryInfoCacheName = recoveryInfoName;
        return this;
    }

    public void validate() {
        if (!this.enabled || this.transaction().useSynchronization()) {
            return;
        }
        if (!this.clustering().cacheMode().isSynchronous()) {
            throw new CacheConfigurationException("Recovery not supported with Asynchronous " + this.clustering().cacheMode().friendlyCacheModeString() + " cache mode.");
        }
        if (!this.transaction().syncCommitPhase()) {
            throw new CacheConfigurationException("Recovery not supported with asynchronous commit phase.");
        }
    }

    public RecoveryConfiguration create() {
        return new RecoveryConfiguration(this.enabled, this.recoveryInfoCacheName);
    }

    public RecoveryConfigurationBuilder read(RecoveryConfiguration template) {
        this.enabled = template.enabled();
        this.recoveryInfoCacheName = template.recoveryInfoCacheName();
        return this;
    }

    public String toString() {
        return "RecoveryConfigurationBuilder{enabled=" + this.enabled + ", recoveryInfoCacheName='" + this.recoveryInfoCacheName + '\'' + '}';
    }
}

