/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfigurationBuilder;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GlobalAuthorizationConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalAuthorizationConfiguration> {
    public static final Log log = LogFactory.getLog(GlobalAuthorizationConfigurationBuilder.class);
    private boolean enabled = false;
    private PrincipalRoleMapper principalRoleMapper;
    private final Map<String, GlobalRoleConfigurationBuilder> roles = new HashMap<String, GlobalRoleConfigurationBuilder>();

    public GlobalAuthorizationConfigurationBuilder(GlobalSecurityConfigurationBuilder builder) {
        super(builder.getGlobalConfig());
    }

    public GlobalAuthorizationConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public GlobalAuthorizationConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public GlobalAuthorizationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GlobalAuthorizationConfigurationBuilder principalRoleMapper(PrincipalRoleMapper principalRoleMapper) {
        this.principalRoleMapper = principalRoleMapper;
        return this;
    }

    public GlobalRoleConfigurationBuilder role(String name) {
        GlobalRoleConfigurationBuilder role = new GlobalRoleConfigurationBuilder(name, this);
        this.roles.put(name, role);
        return role;
    }

    public void validate() {
        if (this.enabled && this.principalRoleMapper == null) {
            throw log.invalidPrincipalRoleMapper();
        }
    }

    public GlobalAuthorizationConfiguration create() {
        HashMap<String, Role> rolesCfg = new HashMap<String, Role>();
        for (GlobalRoleConfigurationBuilder role : this.roles.values()) {
            Role roleCfg = role.create();
            rolesCfg.put(roleCfg.getName(), roleCfg);
        }
        return new GlobalAuthorizationConfiguration(this.enabled, this.principalRoleMapper, rolesCfg);
    }

    public Builder<?> read(GlobalAuthorizationConfiguration template) {
        this.enabled = template.enabled();
        this.principalRoleMapper = template.principalRoleMapper();
        this.roles.clear();
        for (Role role : template.roles().values()) {
            this.role(role.getName()).read(role);
        }
        return this;
    }
}

