/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.executors.LazyInitializingBlockingTaskAwareExecutorService;
import org.infinispan.executors.LazyInitializingExecutorService;
import org.infinispan.executors.LazyInitializingScheduledExecutorService;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;

@DefaultFactoryFor(classes={ExecutorService.class, Executor.class, ScheduledExecutorService.class, BlockingTaskAwareExecutorService.class})
public class NamedExecutorsFactory
extends NamedComponentFactory
implements AutoInstantiableFactory {
    private ExecutorService notificationExecutor;
    private ExecutorService asyncTransportExecutor;
    private ExecutorService persistenceExecutor;
    private BlockingTaskAwareExecutorService remoteCommandsExecutor;
    private ScheduledExecutorService evictionExecutor;
    private ScheduledExecutorService asyncReplicationExecutor;
    private BlockingTaskAwareExecutorService totalOrderExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T construct(Class<T> componentType, String componentName) {
        try {
            if (componentName.equals("org.infinispan.executors.notification")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.notificationExecutor == null) {
                        this.notificationExecutor = this.createExecutorService(this.globalConfiguration.listenerThreadPool(), this.globalConfiguration, "org.infinispan.executors.notification", ExecutorServiceType.DEFAULT);
                    }
                }
                return (T)this.notificationExecutor;
            }
            if (componentName.equals("org.infinispan.executors.persistence")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.persistenceExecutor == null) {
                        this.persistenceExecutor = this.createExecutorService(this.globalConfiguration.persistenceThreadPool(), this.globalConfiguration, "org.infinispan.executors.persistence", ExecutorServiceType.DEFAULT);
                    }
                }
                return (T)this.persistenceExecutor;
            }
            if (componentName.equals("org.infinispan.executors.transport")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.asyncTransportExecutor == null) {
                        this.asyncTransportExecutor = this.createExecutorService(this.globalConfiguration.transport().transportThreadPool(), this.globalConfiguration, "org.infinispan.executors.transport", ExecutorServiceType.DEFAULT);
                    }
                }
                return (T)this.asyncTransportExecutor;
            }
            if (componentName.equals("org.infinispan.executors.eviction")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.evictionExecutor == null) {
                        this.evictionExecutor = (ScheduledExecutorService)this.createExecutorService(this.globalConfiguration.evictionThreadPool(), this.globalConfiguration, "org.infinispan.executors.eviction", ExecutorServiceType.SCHEDULED);
                    }
                }
                return (T)this.evictionExecutor;
            }
            if (componentName.equals("org.infinispan.executors.replicationQueue")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.asyncReplicationExecutor == null) {
                        this.asyncReplicationExecutor = (ScheduledExecutorService)this.createExecutorService(this.globalConfiguration.replicationQueueThreadPool(), this.globalConfiguration, "org.infinispan.executors.replicationQueue", ExecutorServiceType.SCHEDULED);
                    }
                }
                return (T)this.asyncReplicationExecutor;
            }
            if (componentName.equals("org.infinispan.executors.remote")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.remoteCommandsExecutor == null) {
                        this.remoteCommandsExecutor = (BlockingTaskAwareExecutorService)this.createExecutorService(this.globalConfiguration.replicationQueueThreadPool(), this.globalConfiguration, "org.infinispan.executors.remote", ExecutorServiceType.BLOCKING);
                    }
                }
                return (T)this.remoteCommandsExecutor;
            }
            if (componentName.equals("org.infinispan.executors.totalOrderExecutor")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.totalOrderExecutor == null) {
                        this.totalOrderExecutor = (BlockingTaskAwareExecutorService)this.createExecutorService(this.globalConfiguration.transport().totalOrderThreadPool(), this.globalConfiguration, "org.infinispan.executors.totalOrderExecutor", ExecutorServiceType.BLOCKING);
                    }
                }
                return (T)this.totalOrderExecutor;
            }
            throw new CacheConfigurationException("Unknown named executor " + componentName);
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to instantiate ExecutorFactory for named component " + componentName, (Throwable)e);
        }
    }

    @Stop(priority=999)
    public void stop() {
        if (this.remoteCommandsExecutor != null) {
            this.remoteCommandsExecutor.shutdownNow();
        }
        if (this.notificationExecutor != null) {
            this.notificationExecutor.shutdownNow();
        }
        if (this.persistenceExecutor != null) {
            this.persistenceExecutor.shutdownNow();
        }
        if (this.asyncTransportExecutor != null) {
            this.asyncTransportExecutor.shutdownNow();
        }
        if (this.asyncReplicationExecutor != null) {
            this.asyncReplicationExecutor.shutdownNow();
        }
        if (this.evictionExecutor != null) {
            this.evictionExecutor.shutdownNow();
        }
        if (this.totalOrderExecutor != null) {
            this.totalOrderExecutor.shutdownNow();
        }
    }

    private <T extends ExecutorService> T createExecutorService(ThreadPoolConfiguration threadPoolConfiguration, GlobalConfiguration globalCfg, String componentName, ExecutorServiceType type) {
        Object executorFactory;
        ThreadFactory threadFactory;
        if (threadPoolConfiguration != null) {
            threadFactory = threadPoolConfiguration.threadFactory() != null ? threadPoolConfiguration.threadFactory() : this.createThreadFactoryWithDefaults(globalCfg, componentName);
            executorFactory = threadPoolConfiguration.threadPoolFactory() != null ? threadPoolConfiguration.threadPoolFactory() : this.createThreadPoolFactoryWithDefaults(componentName, type);
        } else {
            threadFactory = this.createThreadFactoryWithDefaults(globalCfg, componentName);
            executorFactory = this.createThreadPoolFactoryWithDefaults(componentName, type);
        }
        switch (type) {
            case SCHEDULED: {
                return (T)new LazyInitializingScheduledExecutorService((ThreadPoolExecutorFactory)executorFactory, threadFactory);
            }
            case BLOCKING: {
                return (T)new LazyInitializingBlockingTaskAwareExecutorService((ThreadPoolExecutorFactory)executorFactory, threadFactory, this.globalComponentRegistry.getTimeService());
            }
        }
        return (T)new LazyInitializingExecutorService((ThreadPoolExecutorFactory)executorFactory, threadFactory);
    }

    private ThreadFactory createThreadFactoryWithDefaults(GlobalConfiguration globalCfg, String componentName) {
        return new DefaultThreadFactory(null, KnownComponentNames.getDefaultThreadPrio(componentName), "%c-%n-p%f-t%t", globalCfg.transport().nodeName(), KnownComponentNames.shortened(componentName));
    }

    private ThreadPoolExecutorFactory createThreadPoolFactoryWithDefaults(String componentName, ExecutorServiceType type) {
        switch (type) {
            case SCHEDULED: {
                return ScheduledThreadPoolExecutorFactory.create();
            }
        }
        int defaultQueueSize = KnownComponentNames.getDefaultQueueSize(componentName);
        int defaultMaxThreads = KnownComponentNames.getDefaultThreads(componentName);
        return BlockingThreadPoolExecutorFactory.create((int)defaultMaxThreads, (int)defaultQueueSize);
    }

    private static enum ExecutorServiceType {
        DEFAULT,
        SCHEDULED,
        BLOCKING;

    }
}

