/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.HashSet;
import java.util.List;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            if (returnValue == null) {
                Object key = command.getKey();
                if (this.needsRemoteGet(ctx, command)) {
                    InternalCacheEntry remoteEntry = this.remoteGetCacheEntry(ctx, key, command);
                    returnValue = this.computeGetReturn(remoteEntry, command);
                }
                if (returnValue == null && this.isValueAvailableLocally(this.dm.getReadConsistentHash(), key)) {
                    InternalCacheEntry localEntry = this.localGetCacheEntry(ctx, key, false, command);
                    returnValue = this.computeGetReturn(localEntry, command);
                }
            }
            return returnValue;
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    private Object computeGetReturn(InternalCacheEntry entry, GetKeyValueCommand command) {
        if (!command.isReturnEntry() && entry != null) {
            return entry.getValue();
        }
        return entry;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            HashSet<Address> primaryOwners = new HashSet<Address>(command.getAffectedKeys().size());
            for (Object k : command.getAffectedKeys()) {
                primaryOwners.add(this.cdl.getPrimaryOwner(k));
            }
            primaryOwners.remove(this.rpcManager.getAddress());
            if (!primaryOwners.isEmpty()) {
                this.rpcManager.invokeRemotely(primaryOwners, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command)));
            }
        }
        if (!command.isForwarded()) {
            HashSet<Object> keysIOwn = new HashSet<Object>(command.getAffectedKeys().size());
            for (Object k : command.getAffectedKeys()) {
                if (!this.cdl.localNodeIsPrimaryOwner(k)) continue;
                keysIOwn.add(k);
            }
            List<Address> backupOwners = this.cdl.getOwners(keysIOwn);
            if (backupOwners == null || !backupOwners.isEmpty()) {
                command.setFlags(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                this.rpcManager.invokeRemotely(backupOwners, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command)));
                command.setForwarded(false);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.isLocalModeForced(command)) {
            this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command)));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator keygen) throws Throwable {
        for (Object k : keygen.getKeys()) {
            if (!this.cdl.localNodeIsPrimaryOwner(k)) continue;
            this.localGetCacheEntry(ctx, k, true, command);
        }
    }

    private InternalCacheEntry localGetCacheEntry(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        InternalCacheEntry ice = this.dataContainer.get(key);
        if (ice != null) {
            if (!ctx.replaceValue(key, ice)) {
                if (isWrite) {
                    this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command, true);
                } else {
                    ctx.putLookedUpEntry(key, ice);
                }
            }
            return ice;
        }
        return null;
    }

    private InternalCacheEntry remoteGetCacheEntry(InvocationContext ctx, Object key, GetKeyValueCommand command) throws Throwable {
        if (trace) {
            log.tracef("Doing a remote get for key %s", key);
        }
        InternalCacheEntry ice = this.retrieveFromRemoteSource(key, ctx, false, command, false);
        command.setRemotelyFetchedValue(ice);
        if (ice != null) {
            return ice;
        }
        return null;
    }

    @Override
    protected boolean needValuesFromPreviousOwners(InvocationContext ctx, WriteCommand command) {
        if (command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
            return false;
        }
        if (command.hasFlag(Flag.DELTA_WRITE)) {
            return true;
        }
        if (this.isNeedReliableReturnValues(command) || command.isConditional()) {
            for (Object key : command.getAffectedKeys()) {
                if (!this.cdl.localNodeIsPrimaryOwner(key)) continue;
                return true;
            }
        }
        return false;
    }
}

