/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoverableTransactionIdentifier;
import org.infinispan.transaction.xa.recovery.RecoveryAwareLocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RecoveryAwareTransactionTable
extends XaTransactionTable {
    private static final Log log = LogFactory.getLog(RecoveryAwareTransactionTable.class);
    private RecoveryManagerImpl recoveryManager;

    @Inject
    public void initialize(RecoveryManager recoveryManager) {
        this.recoveryManager = (RecoveryManagerImpl)recoveryManager;
    }

    @Override
    public void remoteTransactionPrepared(GlobalTransaction gtx) {
        RecoveryAwareRemoteTransaction remoteTransaction = (RecoveryAwareRemoteTransaction)super.getRemoteTransaction(gtx);
        if (remoteTransaction == null) {
            throw new CacheException(String.format("Remote transaction for global transaction (%s) not found", gtx));
        }
        remoteTransaction.setPrepared(true);
    }

    @Override
    public void localTransactionPrepared(LocalTransaction localTransaction) {
        ((RecoveryAwareLocalTransaction)localTransaction).setPrepared(true);
    }

    @Override
    public void cleanupStaleTransactions(CacheTopology cacheTopology) {
        if (this.getMinTopologyId() >= cacheTopology.getTopologyId()) {
            return;
        }
        Iterator<RemoteTransaction> it = this.getRemoteTransactions().iterator();
        while (it.hasNext()) {
            RecoveryAwareRemoteTransaction recTx = (RecoveryAwareRemoteTransaction)it.next();
            if (recTx.getTopologyId() >= cacheTopology.getTopologyId()) continue;
            recTx.computeOrphan(cacheTopology.getMembers());
            if (!recTx.isInDoubt()) continue;
            this.recoveryManager.registerInDoubtTransaction(recTx);
            it.remove();
        }
        super.cleanupStaleTransactions(cacheTopology);
    }

    @Override
    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        RemoteTransaction remoteTransaction = super.getRemoteTransaction(txId);
        if (remoteTransaction != null) {
            return remoteTransaction;
        }
        return this.recoveryManager.getPreparedTransaction(((RecoverableTransactionIdentifier)((Object)txId)).getXid());
    }

    @Override
    public void remoteTransactionRollback(GlobalTransaction gtx) {
        super.remoteTransactionRollback(gtx);
        this.recoveryManager.removeRecoveryInformation(((RecoverableTransactionIdentifier)((Object)gtx)).getXid());
    }

    @Override
    public void remoteTransactionCommitted(GlobalTransaction gtx, boolean onePc) {
        RecoveryAwareRemoteTransaction remoteTransaction = (RecoveryAwareRemoteTransaction)this.getRemoteTransaction(gtx);
        if (remoteTransaction == null) {
            throw new CacheException(String.format("Remote transaction for global transaction (%s) not found", gtx));
        }
        remoteTransaction.markCompleted(true);
        super.remoteTransactionCommitted(gtx, onePc);
    }

    public List<Xid> getLocalPreparedXids() {
        LinkedList<Xid> result = new LinkedList<Xid>();
        for (Map.Entry e : this.xid2LocalTx.entrySet()) {
            RecoveryAwareLocalTransaction value = (RecoveryAwareLocalTransaction)e.getValue();
            if (!value.isPrepared()) continue;
            result.add((Xid)e.getKey());
        }
        return result;
    }

    @Override
    public void failureCompletingTransaction(Transaction tx) {
        RecoveryAwareLocalTransaction localTx = (RecoveryAwareLocalTransaction)this.getLocalTransaction(tx);
        if (localTx == null) {
            throw new CacheException(String.format("Local transaction for transaction (%s) not found", tx));
        }
        localTx.setCompletionFailed(true);
        log.tracef("Marked as completion failed %s", localTx);
    }

    public Set<RecoveryAwareLocalTransaction> getLocalTxThatFailedToComplete() {
        HashSet<RecoveryAwareLocalTransaction> result = new HashSet<RecoveryAwareLocalTransaction>(4);
        for (LocalTransaction lTx : this.xid2LocalTx.values()) {
            RecoveryAwareLocalTransaction lTx1 = (RecoveryAwareLocalTransaction)lTx;
            if (!lTx1.isCompletionFailed()) continue;
            result.add(lTx1);
        }
        return result;
    }

    public Xid getRemoteTransactionXid(Long internalId) {
        for (RemoteTransaction rTx : this.getRemoteTransactions()) {
            RecoverableTransactionIdentifier gtx = (RecoverableTransactionIdentifier)((Object)rTx.getGlobalTransaction());
            if (gtx.getInternalId() != internalId.longValue()) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Found xid %s matching internal id %s", gtx.getXid(), internalId);
            }
            return gtx.getXid();
        }
        log.tracef("Could not find remote transactions matching internal id %s", internalId);
        return null;
    }

    public RemoteTransaction removeRemoteTransaction(Xid xid) {
        if (this.clustered) {
            Iterator<RemoteTransaction> it = this.getRemoteTransactions().iterator();
            while (it.hasNext()) {
                RemoteTransaction next = it.next();
                RecoverableTransactionIdentifier gtx = (RecoverableTransactionIdentifier)((Object)next.getGlobalTransaction());
                if (!xid.equals(gtx.getXid())) continue;
                it.remove();
                this.recalculateMinTopologyIdIfNeeded(next);
                next.notifyOnTransactionFinished();
                return next;
            }
        }
        return null;
    }
}

