/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.Arrays;
import org.infinispan.context.InvocationContext;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

public class XSiteStatePushCommand
extends XSiteReplicateCommand {
    public static final byte COMMAND_ID = 33;
    private XSiteState[] chunk;
    private XSiteStateConsumer consumer;

    public XSiteStatePushCommand(String cacheName, XSiteState[] chunk) {
        super(cacheName);
        this.chunk = chunk;
    }

    public XSiteStatePushCommand(String cacheName) {
        super(cacheName);
    }

    @Override
    public Object performInLocalSite(BackupReceiver receiver) throws Throwable {
        receiver.handleStateTransferState(this);
        return null;
    }

    public XSiteStatePushCommand() {
        super(null);
    }

    public void initialize(XSiteStateConsumer consumer) {
        this.consumer = consumer;
    }

    public XSiteState[] getChunk() {
        return this.chunk;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        this.consumer.applyState(this.chunk);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 33;
    }

    @Override
    public Object[] getParameters() {
        return this.chunk;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 33) {
            throw new IllegalArgumentException("CommandId is not valid! (" + commandId + " != " + 33 + ")");
        }
        this.chunk = (XSiteState[])Arrays.copyOf(parameters, parameters.length, XSiteState[].class);
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        return "XSiteStatePushCommand{cacheName=" + this.cacheName + " (" + this.chunk.length + " keys)" + '}';
    }
}

