/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import org.infinispan.context.InvocationContext;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

public class XSiteStateTransferControlCommand
extends XSiteReplicateCommand {
    public static final int COMMAND_ID = 28;
    private StateTransferControl control;
    private XSiteStateProvider provider;
    private XSiteStateConsumer consumer;
    private XSiteStateTransferManager stateTransferManager;
    private String siteName;

    public XSiteStateTransferControlCommand(String cacheName, StateTransferControl control, String siteName) {
        super(cacheName);
        this.control = control;
        this.siteName = siteName;
    }

    public XSiteStateTransferControlCommand(String cacheName) {
        super(cacheName);
    }

    public XSiteStateTransferControlCommand() {
        super(null);
    }

    @Override
    public Object performInLocalSite(BackupReceiver receiver) throws Throwable {
        receiver.handleStateTransferControl(this);
        return null;
    }

    public final void initialize(XSiteStateProvider provider, XSiteStateConsumer consumer, XSiteStateTransferManager stateTransferManager) {
        this.provider = provider;
        this.consumer = consumer;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        switch (this.control) {
            case START_SEND: {
                this.provider.startStateTransfer(this.siteName, this.getOrigin());
                break;
            }
            case START_RECEIVE: {
                this.consumer.startStateTransfer();
                break;
            }
            case FINISH_RECEIVE: {
                this.consumer.endStateTransfer();
                break;
            }
            case FINISH_SEND: {
                this.stateTransferManager.notifyStatePushFinished(this.siteName, this.getOrigin());
                break;
            }
            case CANCEL_SEND: {
                this.provider.cancelStateTransfer(this.siteName);
            }
        }
        return null;
    }

    @Override
    public byte getCommandId() {
        return 28;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.control, this.siteName};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 28) {
            throw new IllegalArgumentException("CommandId is not valid! (" + commandId + " != " + 28 + ")");
        }
        this.control = (StateTransferControl)((Object)parameters[0]);
        this.siteName = (String)parameters[1];
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    public static enum StateTransferControl {
        START_SEND,
        START_RECEIVE,
        FINISH_SEND,
        FINISH_RECEIVE,
        CANCEL_SEND;

    }
}

