/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.container;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;

public class SerialExecutor
implements Executor {
    final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    final Executor executor;
    Runnable active;

    public SerialExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public synchronized void execute(final Runnable r) {
        this.tasks.offer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    SerialExecutor.this.scheduleNext();
                }
            }
        });
        if (this.active == null) {
            this.scheduleNext();
        }
    }

    protected synchronized void scheduleNext() {
        this.active = this.tasks.poll();
        if (this.active != null) {
            this.executor.execute(this.active);
        }
    }
}

