/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.atomic.Updatable;
import org.infinispan.atomic.Update;
import org.infinispan.atomic.container.Container;
import org.infinispan.atomic.container.ContainerSignature;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AtomicObjectFactory {
    private static Log log = LogFactory.getLog(AtomicObjectFactory.class);
    private static Map<Cache, AtomicObjectFactory> factories = new HashMap<Cache, AtomicObjectFactory>();
    protected static final int MAX_CONTAINERS = 1000;
    public static final Map<Class, List<String>> updateMethods = new HashMap<Class, List<String>>();
    private Cache cache;
    private Map<ContainerSignature, Container> registeredContainers;
    private int maxSize;
    private final ExecutorService evictionExecutor = Executors.newCachedThreadPool();

    public static synchronized AtomicObjectFactory forCache(Cache cache) {
        if (!factories.containsKey(cache)) {
            factories.put(cache, new AtomicObjectFactory((Cache<Object, Object>)cache));
        }
        return factories.get(cache);
    }

    public AtomicObjectFactory(Cache<Object, Object> c, int m) throws InvalidCacheUsageException {
        this.cache = c;
        this.maxSize = m;
        this.registeredContainers = new LinkedHashMap<ContainerSignature, Container>(){

            @Override
            protected boolean removeEldestEntry(final Map.Entry<ContainerSignature, Container> eldest) {
                if (AtomicObjectFactory.this.maxSize != 0 && this.size() >= AtomicObjectFactory.this.maxSize) {
                    AtomicObjectFactory.this.evictionExecutor.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws IOException {
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debugf("Disposing %s", (Object)((Container)eldest.getValue()).toString());
                                }
                                ((Container)eldest.getValue()).dispose(false);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return null;
                        }
                    });
                    return true;
                }
                return false;
            }
        };
        log = LogFactory.getLog(this.getClass());
    }

    public AtomicObjectFactory(Cache<Object, Object> c) throws InvalidCacheUsageException {
        this(c, 1000);
    }

    public synchronized <T> T getInstanceOf(Class<T> clazz, Object key) throws InvalidCacheUsageException {
        return this.getInstanceOf(clazz, key, false);
    }

    public <T> T getInstanceOf(Class<T> clazz, Object key, boolean withReadOptimization) throws InvalidCacheUsageException {
        return this.getInstanceOf(clazz, key, withReadOptimization, null, true, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInstanceOf(Class<T> clazz, Object key, boolean withReadOptimization, Method equalsMethod, boolean forceNew, Object ... initArgs) throws InvalidCacheUsageException {
        Container container;
        block17: {
            if (!Serializable.class.isAssignableFrom(clazz)) {
                throw new InvalidCacheUsageException("The object must be serializable.");
            }
            ContainerSignature signature = new ContainerSignature(clazz, key);
            try {
                Map<ContainerSignature, Container> map = this.registeredContainers;
                synchronized (map) {
                    container = this.registeredContainers.get(signature);
                }
                if (container != null) break block17;
                List<String> methods = Collections.EMPTY_LIST;
                if (Updatable.class.isAssignableFrom(clazz)) {
                    methods = new ArrayList<String>();
                    for (Method m : clazz.getDeclaredMethods()) {
                        if (!m.isAnnotationPresent(Update.class)) continue;
                        methods.add(m.getName());
                    }
                } else {
                    for (Class c : updateMethods.keySet()) {
                        if (!c.isAssignableFrom(clazz)) continue;
                        methods = updateMethods.get(c);
                        break;
                    }
                    if (methods.isEmpty()) {
                        methods = new ArrayList();
                        for (Method m : clazz.getDeclaredMethods()) {
                            methods.add(m.getName());
                        }
                    }
                }
                container = new Container(this.cache, clazz, key, withReadOptimization, forceNew, methods, initArgs);
                Map<ContainerSignature, Container> map2 = this.registeredContainers;
                synchronized (map2) {
                    if (this.registeredContainers.containsKey(signature)) {
                        container.dispose(false);
                    } else {
                        this.registeredContainers.put(signature, container);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvalidCacheUsageException(e.getCause());
            }
        }
        return (T)container.getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeInstanceOf(Class clazz, Object key, boolean keepPersistent) throws InvalidCacheUsageException {
        Container container;
        ContainerSignature signature = new ContainerSignature(clazz, key);
        if (log.isDebugEnabled()) {
            log.debugf("Disposing %s", (Object)signature.toString());
        }
        Map<ContainerSignature, Container> map = this.registeredContainers;
        synchronized (map) {
            container = this.registeredContainers.get(signature);
            if (container == null) {
                return;
            }
            if (!container.getClazz().equals(clazz)) {
                throw new InvalidCacheUsageException("The object is not of the right class.");
            }
            this.registeredContainers.remove(signature);
        }
        try {
            container.dispose(keepPersistent);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidCacheUsageException("Error while disposing object " + key);
        }
    }

    static {
        updateMethods.put(List.class, new ArrayList());
        updateMethods.get(List.class).add("add");
        updateMethods.get(List.class).add("addAll");
        updateMethods.put(Set.class, new ArrayList());
        updateMethods.get(Set.class).add("add");
        updateMethods.get(Set.class).add("addAll");
        updateMethods.put(Map.class, new ArrayList());
        updateMethods.get(Map.class).add("put");
        updateMethods.get(Map.class).add("putAll");
    }
}

