/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.sharded.collections;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.atomic.AtomicObjectFactory;
import org.infinispan.atomic.Updatable;
import org.infinispan.atomic.Update;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ShardedTreeMap<K extends Comparable<K>, V>
extends Updatable
implements SortedMap<K, V> {
    private static Log log = LogFactory.getLog(ShardedTreeMap.class);
    private static final int DEFAULT_THRESHOLD = 1000;
    private SortedMap<K, TreeMap<K, V>> forest;
    private int threshold;

    public ShardedTreeMap() {
        this.forest = new TreeMap<K, TreeMap<K, V>>();
        this.threshold = 1000;
    }

    public ShardedTreeMap(Integer threshhold) {
        assert (threshhold >= 1);
        this.forest = new TreeMap<K, TreeMap<K, V>>();
        this.threshold = threshhold;
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        Comparable key;
        TreeMap result = new TreeMap();
        Iterator<K> iterator = this.forest.keySet().iterator();
        while (iterator.hasNext() && (key = (Comparable)iterator.next()).compareTo(k2) <= 0) {
            this.allocateTree(key);
            result.putAll(((TreeMap)this.forest.get(key)).subMap(k, k2));
        }
        this.unallocateTrees();
        return result;
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        Comparable key;
        TreeMap result = new TreeMap();
        Iterator<K> iterator = this.forest.keySet().iterator();
        while (iterator.hasNext() && (key = (Comparable)iterator.next()).compareTo(toKey) <= 0) {
            this.allocateTree(key);
            result.putAll(((TreeMap)this.forest.get(key)).headMap(toKey));
        }
        this.unallocateTrees();
        return result;
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        TreeMap result = new TreeMap();
        for (Comparable key : this.forest.keySet()) {
            this.allocateTree(key);
            result.putAll(((TreeMap)this.forest.get(key)).tailMap(fromKey));
        }
        this.unallocateTrees();
        return result;
    }

    @Override
    public K firstKey() {
        if (this.forest.isEmpty()) {
            return null;
        }
        this.allocateTree((Comparable)this.forest.firstKey());
        assert (!((TreeMap)this.forest.get(this.forest.firstKey())).isEmpty()) : this.forest.toString();
        Comparable ret = (Comparable)((TreeMap)this.forest.get(this.forest.firstKey())).firstKey();
        this.unallocateTrees();
        return (K)ret;
    }

    @Override
    public K lastKey() {
        if (this.forest.isEmpty()) {
            return null;
        }
        Comparable last = (Comparable)this.forest.lastKey();
        this.allocateTree(last);
        if (!((TreeMap)this.forest.get(last)).isEmpty()) {
            last = (Comparable)((TreeMap)this.forest.get(last)).lastKey();
        }
        this.unallocateTrees();
        return (K)last;
    }

    @Override
    public int size() {
        int ret = 0;
        for (Comparable v : this.forest.keySet()) {
            this.allocateTree(v);
            ret += ((TreeMap)this.forest.get(v)).size();
        }
        this.unallocateTrees();
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.forest.isEmpty();
    }

    @Override
    public V get(Object o) {
        if (this.forest.isEmpty()) {
            return null;
        }
        Comparable last = (Comparable)this.forest.lastKey();
        TreeMap<Comparable, V> treeMap = this.allocateTree(last);
        assert (!treeMap.isEmpty());
        V ret = treeMap.lastEntry().getValue();
        this.unallocateTrees();
        return ret;
    }

    @Override
    @Update
    public V put(K k, V v) {
        V ret = this.doPut(k, v);
        this.unallocateTrees();
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return this.forest.hashCode();
    }

    @Override
    @Update
    public void putAll(Map<? extends K, ? extends V> map) {
        if (this.forest.isEmpty()) {
            TreeMap<Comparable, V> treeMap = new TreeMap<Comparable, V>(map);
            int split = treeMap.size() / this.threshold + 1;
            Comparable beg = (Comparable)treeMap.firstKey();
            for (int i = 0; i < split; ++i) {
                TreeMap sub = this.allocateTree(beg);
                this.forest.put(beg, sub);
                TreeMap<Comparable, V> toAdd = new TreeMap<Comparable, V>();
                for (Comparable k : treeMap.tailMap(beg).keySet()) {
                    if (toAdd.size() == this.threshold) {
                        beg = k;
                        break;
                    }
                    toAdd.put(k, treeMap.get(k));
                }
                sub.putAll(toAdd);
            }
        } else {
            for (Comparable k : map.keySet()) {
                this.doPut(k, map.get(k));
            }
        }
        this.unallocateTrees();
    }

    public String toString() {
        TreeMap all = new TreeMap();
        for (Comparable key : this.forest.keySet()) {
            this.allocateTree(key);
            all.putAll((Map)this.forest.get(key));
        }
        this.unallocateTrees();
        return all.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new ArrayList<K>(this.forest.keySet()));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.forest = new TreeMap<K, TreeMap<K, V>>();
        for (Comparable k : (List)objectInput.readObject()) {
            this.forest.put(k, null);
        }
    }

    private V doPut(K k, V v) {
        log.debug((Object)("adding " + k + "=" + v));
        SortedMap<K, TreeMap<K, V>> headMap = this.forest.headMap(k);
        Object key = !headMap.isEmpty() && this.allocateTree((Comparable)headMap.lastKey()).size() < this.threshold ? (Comparable)headMap.lastKey() : k;
        TreeMap<K, V> tree = this.allocateTree(key);
        V ret = tree.put(k, v);
        log.debug((Object)("in tree " + key + " -> " + tree));
        if (key != k && ((Comparable)tree.firstKey()).equals(k)) {
            this.forest.remove(key);
            this.forest.put(k, tree);
        }
        if (tree.size() > this.threshold) {
            Map.Entry<K, V> entry = tree.lastEntry();
            tree.remove(entry.getKey());
            this.put((K)((Comparable)entry.getKey()), entry.getValue());
        }
        return ret;
    }

    private TreeMap<K, V> allocateTree(K k) {
        log.debug((Object)("Allocating " + k));
        if (this.forest.get(k) == null) {
            TreeMap treeMap = AtomicObjectFactory.forCache(this.getCache()).getInstanceOf(TreeMap.class, this.getKey().toString() + ":" + k.toString(), true, null, false, new Object[0]);
            this.forest.put(k, treeMap);
            log.debug((Object)"... done ");
        }
        return (TreeMap)this.forest.get(k);
    }

    private void unallocateTrees() {
        ArrayList<Comparable> toUnallocate = new ArrayList<Comparable>();
        for (Comparable k : this.forest.keySet()) {
            if (this.forest.get(k) == null) continue;
            toUnallocate.add(k);
        }
        for (Comparable k : toUnallocate) {
            log.debug((Object)("Unallocate " + k));
            AtomicObjectFactory.forCache(this.getCache()).disposeInstanceOf(TreeMap.class, this.getKey().toString() + ":" + k.toString(), true);
            this.forest.put(k, null);
        }
    }

    @Override
    public boolean containsKey(Object o) {
        for (Comparable k : this.forest.keySet()) {
            this.allocateTree(k);
            if (!((TreeMap)this.forest.get(k)).containsKey(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object o) {
        throw new UnsupportedOperationException("to be implemented");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("to be implemented");
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("to be implemented");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("to be implemented");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("to be implemented");
    }

    @Override
    public boolean containsValue(Object o) {
        throw new UnsupportedOperationException("to be implemented");
    }

    @Override
    public Comparator<? super K> comparator() {
        throw new UnsupportedOperationException("to be implemented");
    }
}

