/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.container;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.infinispan.Cache;
import org.infinispan.atomic.Updatable;
import org.infinispan.atomic.container.Call;
import org.infinispan.atomic.container.CallFuture;
import org.infinispan.atomic.container.CallInvoke;
import org.infinispan.atomic.container.CallPersist;
import org.infinispan.atomic.container.CallRetrieve;
import org.infinispan.atomic.container.SerialExecutor;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener(sync=false, clustered=true, primaryOnly=true)
public class Container {
    private static final MethodFilter methodFilter = new MethodFilter(){

        public boolean isHandled(Method m) {
            return !m.getName().equals("finalize") && !m.getName().equals("readExternal") && !m.getName().equals("writeExternal");
        }
    };
    private static Log log = LogFactory.getLog(Container.class);
    private static final int CALL_TTIMEOUT_TIME = 3000;
    private static final int RETRIEVE_TTIMEOUT_TIME = 3000;
    private static Executor globalExecutors = Executors.newCachedThreadPool();
    private Cache cache;
    private Object key;
    private Object object;
    private Class clazz;
    private Object proxy;
    private List<String> updateMethods;
    private Executor callExecutor = new SerialExecutor(globalExecutors);
    private Boolean withReadOptimization;
    private volatile int listenerState;
    private final Container listener = this;
    private Map<Long, CallFuture> registeredCalls;
    private CallFuture retrieve_future;
    private ArrayList<CallInvoke> pending_calls;
    private CallRetrieve retrieve_call;

    public Container(Cache c, Class cl, Object k, boolean readOptimization, final boolean forceNew, List<String> methods, final Object ... initArgs) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, InterruptedException, ExecutionException, NoSuchMethodException, InvocationTargetException {
        this.cache = c;
        this.clazz = cl;
        this.key = this.clazz.getSimpleName() + "#" + k.toString();
        this.withReadOptimization = readOptimization;
        this.listenerState = 0;
        this.updateMethods = methods;
        this.registeredCalls = new ConcurrentHashMap<Long, CallFuture>();
        MethodHandler handler = new MethodHandler(){

            public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Throwable {
                GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
                if (Container.this.withReadOptimization.booleanValue() && !Container.this.updateMethods.contains(m.getName())) {
                    if (log.isDebugEnabled()) {
                        log.debugf("Executing %s locally", (Object)m.getName());
                    }
                    return Container.this.callObject(Container.this.object, m.getName(), args);
                }
                Container.this.initObject(true, forceNew, initArgs);
                long callID = Container.this.nextCallID();
                CallInvoke invoke = new CallInvoke(callID, m.getName(), args);
                byte[] bb = marshaller.objectToByteBuffer((Object)invoke);
                CallFuture future = new CallFuture();
                Container.this.registeredCalls.put(callID, future);
                Container.this.cache.put(Container.this.key, (Object)bb);
                if (log.isDebugEnabled()) {
                    log.debugf("Waiting on %s", (Object)future.toString());
                }
                Object ret = future.get(3000L, TimeUnit.MILLISECONDS);
                Container.this.registeredCalls.remove(callID);
                if (!future.isDone()) {
                    throw new TimeoutException("Unable to execute " + invoke + " on " + Container.this.clazz + " @ " + Container.this.key);
                }
                if (log.isDebugEnabled()) {
                    log.debugf("Return %s %s ", (Object)invoke.toString(), (Object)(ret == null ? "null" : ret.toString()));
                }
                return ret;
            }
        };
        ProxyFactory fact = new ProxyFactory();
        fact.setSuperclass(this.clazz);
        fact.setFilter(methodFilter);
        this.proxy = fact.createClass().newInstance();
        ((ProxyObject)this.proxy).setHandler(handler);
        this.initObject(false, forceNew, initArgs);
    }

    @CacheEntryModified
    @CacheEntryCreated
    @Deprecated
    public void onCacheModification(CacheEntryEvent event) {
        if (!event.getKey().equals(this.key)) {
            return;
        }
        if (event.isPre()) {
            return;
        }
        try {
            GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
            byte[] bb = (byte[])event.getValue();
            Call call = (Call)marshaller.objectFromByteBuffer(bb);
            if (log.isDebugEnabled()) {
                log.debugf("Receive %s (isOriginLocal=%s) ", (Object)call, (Object)event.isOriginLocal());
            }
            this.callExecutor.execute(new AtomicObjectContainerTask(call));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void dispose(boolean keepPersistent) throws IOException, InterruptedException {
        if (log.isDebugEnabled()) {
            log.debugf("Disposing ", new Object[0]);
        }
        if (!this.registeredCalls.isEmpty()) {
            log.warnf("Cannot dispose - registeredCalls non-empty", new Object[0]);
            return;
        }
        if (this.listenerState == 1) {
            this.cache.removeListener((Object)this.listener);
            if (keepPersistent) {
                if (log.isDebugEnabled()) {
                    log.debugf("Persisted", new Object[0]);
                }
                GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
                CallPersist persist = new CallPersist(0L, this.object);
                byte[] bb = marshaller.objectToByteBuffer((Object)persist);
                this.cache.put(this.key, (Object)bb);
            }
        }
        this.listenerState = -1;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public String toString() {
        return "Container [" + this.key.toString() + "]";
    }

    private boolean handleInvocation(CallInvoke invocation) throws InvocationTargetException, IllegalAccessException {
        Object ret = this.callObject(this.object, invocation.method, invocation.arguments);
        CallFuture future = this.registeredCalls.get(invocation.callID);
        if (future != null) {
            if (log.isDebugEnabled()) {
                log.debugf("Updating %s", (Object)future.toString());
            }
            future.setReturnValue(ret);
            return true;
        }
        log.debugf("No future for %s", invocation.callID);
        return false;
    }

    private void initObject(boolean installListener, boolean forceNew, Object ... initArgs) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Constructor<?>[] allConstructors;
        block20: {
            if (!(this.object == null || installListener && this.listenerState != 1)) {
                return;
            }
            if (installListener) {
                this.installListener();
            }
            if (!forceNew) {
                GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
                try {
                    Call persist = (Call)marshaller.objectFromByteBuffer((byte[])this.cache.get(this.key));
                    if (persist instanceof CallPersist) {
                        if (log.isDebugEnabled()) {
                            log.debugf("Persisted %s", (Object)this.key.toString());
                        }
                        this.object = ((CallPersist)persist).object;
                    } else {
                        this.installListener();
                        if (log.isDebugEnabled()) {
                            log.debugf("Retrieving object %s", (Object)this.key.toString());
                        }
                        if (!installListener) {
                            throw new IllegalAccessException();
                        }
                        this.retrieve_future = new CallFuture();
                        this.retrieve_call = new CallRetrieve(this.nextCallID());
                        marshaller = new GenericJBossMarshaller();
                        this.cache.put(this.key, (Object)marshaller.objectToByteBuffer((Object)this.retrieve_call));
                        this.retrieve_future.get(3000L, TimeUnit.MILLISECONDS);
                        if (!this.retrieve_future.isDone()) {
                            throw new TimeoutException();
                        }
                        if (log.isDebugEnabled()) {
                            log.debugf("Object %s retrieved", (Object)this.key.toString());
                        }
                        assert (this.object != null);
                    }
                    if (this.object instanceof Updatable) {
                        ((Updatable)this.object).setCache(this.cache);
                        ((Updatable)this.object).setKey(this.key);
                    }
                    return;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block20;
                    log.debugf("Unable to retrieve object %s from the cache.", (Object)this.key.toString());
                }
            }
        }
        boolean found = false;
        for (Constructor<?> ctor : allConstructors = this.clazz.getDeclaredConstructors()) {
            Class<?>[] pType = ctor.getParameterTypes();
            if (pType.length != initArgs.length) continue;
            found = true;
            for (int i = 0; i < pType.length; ++i) {
                if (pType[i].isAssignableFrom(initArgs[i].getClass())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.object = ctor.newInstance(initArgs);
            break;
        }
        if (this.object instanceof Updatable) {
            ((Updatable)this.object).setCache(this.cache);
            ((Updatable)this.object).setKey(this.key);
        }
        if (found) {
            if (log.isDebugEnabled()) {
                log.debugf("Object %s[%s] is created (AtomicObject=%s)", (Object)this.key.toString(), (Object)this.clazz.getSimpleName(), (Object)Boolean.toString(this.object instanceof Updatable));
            }
        } else {
            throw new IllegalArgumentException("Unable to find constructor for " + this.clazz.toString() + " with " + initArgs);
        }
    }

    private void installListener() {
        if (this.listenerState == 1) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Installing listener %s", this.key);
        }
        this.cache.addListener((Object)this.listener);
        this.listenerState = 1;
    }

    private long nextCallID() {
        Random random = new Random(System.nanoTime());
        return Thread.currentThread().getId() * random.nextLong();
    }

    private synchronized Object callObject(Object obj, String method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (log.isDebugEnabled()) {
            log.debugf("Calling %s()", (Object)method.toString());
        }
        boolean isFound = false;
        Object ret = null;
        for (Method m : obj.getClass().getMethods()) {
            if (!method.equals(m.getName())) continue;
            boolean isAssignable = true;
            Class<?>[] argsTypes = m.getParameterTypes();
            if (argsTypes.length == args.length) {
                for (int i = 0; i < argsTypes.length; ++i) {
                    if (argsTypes[i].isAssignableFrom(args[i].getClass())) continue;
                    isAssignable = false;
                    break;
                }
            } else {
                isAssignable = false;
            }
            if (!isAssignable) continue;
            ret = m.invoke(obj, args);
            isFound = true;
            break;
        }
        if (!isFound) {
            throw new IllegalStateException("Method " + method + " not found.");
        }
        return ret;
    }

    private class AtomicObjectContainerTask
    implements Runnable {
        public Call call;

        public AtomicObjectContainerTask(Call c) {
            this.call = c;
        }

        @Override
        public void run() {
            try {
                if (this.call instanceof CallInvoke) {
                    if (Container.this.object != null) {
                        CallInvoke invocation = (CallInvoke)this.call;
                        Container.this.handleInvocation(invocation);
                    } else if (Container.this.pending_calls != null) {
                        Container.this.pending_calls.add((CallInvoke)this.call);
                    }
                } else if (this.call instanceof CallRetrieve) {
                    if (Container.this.object != null) {
                        if (log.isDebugEnabled()) {
                            log.debugf("Sending persistent state", new Object[0]);
                        }
                        CallPersist persist = new CallPersist(0L, Container.this.object);
                        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
                        Container.this.cache.put(Container.this.key, (Object)marshaller.objectToByteBuffer((Object)persist));
                    } else if (Container.this.retrieve_call != null && ((Container)Container.this).retrieve_call.callID == ((CallRetrieve)this.call).callID) {
                        assert (Container.this.pending_calls == null);
                        Container.this.pending_calls = new ArrayList();
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debugf("Persistent state received", new Object[0]);
                    }
                    if (Container.this.object == null && Container.this.pending_calls != null) {
                        Container.this.object = ((CallPersist)this.call).object;
                        for (CallInvoke invocation : Container.this.pending_calls) {
                            Container.this.handleInvocation(invocation);
                        }
                        Container.this.pending_calls = null;
                        Container.this.retrieve_future.setReturnValue(null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

