/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.cassandra.service.EmbeddedCassandraService;
import org.apache.thrift.transport.TTransportException;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.cassandra.CassandraCacheStore;
import org.infinispan.loaders.cassandra.CassandraCacheStoreConfig;
import org.infinispan.loaders.cassandra.CassandraServiceDataCleaner;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.cassandra.CassandraCacheStoreTest")
public class CassandraCacheStoreTest
extends BaseCacheStoreTest {
    private static EmbeddedCassandraService cassandra;

    @BeforeClass
    public static void setup() throws TTransportException, IOException, InterruptedException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("storage-conf.xml");
        String configPath = resource.getPath().substring(0, resource.getPath().lastIndexOf(File.separatorChar));
        System.setProperty("storage-config", configPath);
        CassandraServiceDataCleaner cleaner = new CassandraServiceDataCleaner();
        cleaner.prepare();
        cassandra = new EmbeddedCassandraService();
        cassandra.init();
        Thread t = new Thread((Runnable)cassandra);
        t.setDaemon(true);
        t.start();
    }

    protected CacheStore createCacheStore() throws Exception {
        CassandraCacheStore cs = new CassandraCacheStore();
        CassandraCacheStoreConfig clc = new CassandraCacheStoreConfig();
        clc.setHost("localhost");
        cs.init((CacheLoaderConfig)clc, this.getCache(), this.getMarshaller());
        cs.start();
        return cs;
    }
}

