/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dataforte.cassandra.pool.ConnectionPool;
import net.dataforte.cassandra.pool.PoolConfiguration;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.infinispan.Cache;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.cassandra.CassandraCacheStoreConfig;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=CassandraCacheStoreConfig.class)
public class CassandraCacheStore
extends AbstractCacheStore {
    private static final String ENTRY_KEY_PREFIX = "entry_";
    private static final String ENTRY_COLUMN_NAME = "entry";
    private static final String EXPIRATION_KEY = "expiration";
    private static final int SLICE_SIZE = 100;
    private static final Log log = LogFactory.getLog(CassandraCacheStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private CassandraCacheStoreConfig config;
    private ConnectionPool pool;
    private ColumnPath entryColumnPath;
    private ColumnParent entryColumnParent;
    private ColumnParent expirationColumnParent;
    private static byte[] emptyByteArray = new byte[0];

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return CassandraCacheStoreConfig.class;
    }

    public void init(CacheLoaderConfig clc, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(clc, cache, m);
        this.config = (CassandraCacheStoreConfig)clc;
    }

    public void start() throws CacheLoaderException {
        try {
            this.pool = new ConnectionPool((PoolConfiguration)this.config.getPoolProperties());
            this.entryColumnPath = new ColumnPath(this.config.entryColumnFamily).setColumn(ENTRY_COLUMN_NAME.getBytes("UTF-8"));
            this.entryColumnParent = new ColumnParent(this.config.entryColumnFamily);
            this.expirationColumnParent = new ColumnParent(this.config.expirationColumnFamily);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        log.debug((Object)"cleaning up expired entries...");
        this.purgeInternal();
        log.debug((Object)"started");
        super.start();
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        String hashKey = CassandraCacheStore.hashKey(key);
        Cassandra.Iface cassandraClient = null;
        try {
            cassandraClient = this.pool.getConnection();
            ColumnOrSuperColumn column = cassandraClient.get(this.config.keySpace, hashKey, this.entryColumnPath, ConsistencyLevel.ONE);
            InternalCacheEntry ice = this.unmarshall(column.getColumn().getValue(), key);
            if (ice != null && ice.isExpired()) {
                this.remove(key);
                InternalCacheEntry internalCacheEntry = null;
                return internalCacheEntry;
            }
            InternalCacheEntry internalCacheEntry = ice;
            return internalCacheEntry;
        }
        catch (NotFoundException nfe) {
            log.debug((Object)"Key '{0}' not found", new Object[]{hashKey});
            InternalCacheEntry internalCacheEntry = null;
            return internalCacheEntry;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.pool.release(cassandraClient);
        }
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return this.load(Integer.MAX_VALUE);
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        Cassandra.Iface cassandraClient = null;
        try {
            cassandraClient = this.pool.getConnection();
            HashSet<InternalCacheEntry> s = new HashSet<InternalCacheEntry>();
            SlicePredicate slicePredicate = new SlicePredicate();
            slicePredicate.setSlice_range(new SliceRange(this.entryColumnPath.getColumn(), emptyByteArray, false, 1));
            String startKey = "";
            int sliceSize = Math.min(100, numEntries);
            boolean complete = false;
            while (!complete) {
                KeyRange keyRange = new KeyRange(sliceSize);
                keyRange.setStart_token(startKey);
                keyRange.setEnd_token("");
                List keySlices = cassandraClient.get_range_slices(this.config.keySpace, this.entryColumnParent, slicePredicate, keyRange, ConsistencyLevel.ONE);
                for (KeySlice keySlice : keySlices) {
                    String key = CassandraCacheStore.unhashKey(keySlice.getKey());
                    if (key == null) continue;
                    List columns = keySlice.getColumns();
                    if (columns.size() > 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Loading {0}", new Object[]{key});
                        }
                        byte[] value = ((ColumnOrSuperColumn)columns.get(0)).getColumn().getValue();
                        InternalCacheEntry ice = this.unmarshall(value, key);
                        s.add(ice);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Skipping empty key {0}", new Object[]{key});
                }
                if (keySlices.size() < sliceSize) {
                    complete = true;
                    continue;
                }
                sliceSize = Math.min(100, numEntries - s.size());
                if (sliceSize == 0) {
                    complete = true;
                    continue;
                }
                startKey = ((KeySlice)keySlices.get(keySlices.size() - 1)).getKey();
            }
            HashSet<InternalCacheEntry> hashSet = s;
            return hashSet;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.pool.release(cassandraClient);
        }
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        Cassandra.Iface cassandraClient = null;
        try {
            cassandraClient = this.pool.getConnection();
            HashSet<Object> s = new HashSet<Object>();
            SlicePredicate slicePredicate = new SlicePredicate();
            slicePredicate.setSlice_range(new SliceRange(this.entryColumnPath.getColumn(), emptyByteArray, false, 1));
            String startKey = "";
            boolean complete = false;
            while (!complete) {
                KeyRange keyRange = new KeyRange(100);
                keyRange.setStart_token(startKey);
                keyRange.setEnd_token("");
                List keySlices = cassandraClient.get_range_slices(this.config.keySpace, this.entryColumnParent, slicePredicate, keyRange, ConsistencyLevel.ONE);
                if (keySlices.size() < 100) {
                    complete = true;
                } else {
                    startKey = ((KeySlice)keySlices.get(keySlices.size() - 1)).getKey();
                }
                for (KeySlice keySlice : keySlices) {
                    String key;
                    if (keySlice.getColumnsSize() <= 0 || (key = CassandraCacheStore.unhashKey(keySlice.getKey())) == null || keysToExclude != null && keysToExclude.contains(key)) continue;
                    s.add(key);
                }
            }
            HashSet<Object> hashSet = s;
            return hashSet;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.pool.release(cassandraClient);
        }
    }

    public void stop() {
        this.pool.close();
    }

    public void clear() throws CacheLoaderException {
        Cassandra.Iface cassandraClient = null;
        try {
            cassandraClient = this.pool.getConnection();
            SlicePredicate slicePredicate = new SlicePredicate();
            slicePredicate.setSlice_range(new SliceRange(this.entryColumnPath.getColumn(), emptyByteArray, false, 1));
            String startKey = "";
            boolean complete = false;
            while (!complete) {
                KeyRange keyRange = new KeyRange(100);
                keyRange.setStart_token(startKey);
                keyRange.setEnd_token("");
                List keySlices = cassandraClient.get_range_slices(this.config.keySpace, this.entryColumnParent, slicePredicate, keyRange, ConsistencyLevel.ONE);
                if (keySlices.size() < 100) {
                    complete = true;
                } else {
                    startKey = ((KeySlice)keySlices.get(keySlices.size() - 1)).getKey();
                }
                HashMap<String, Map<String, List<Mutation>>> mutationMap = new HashMap<String, Map<String, List<Mutation>>>();
                for (KeySlice keySlice : keySlices) {
                    String cassandraKey = keySlice.getKey();
                    this.remove0(cassandraKey, mutationMap);
                }
                cassandraClient.batch_mutate(this.config.keySpace, mutationMap, ConsistencyLevel.ALL);
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.pool.release(cassandraClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key) throws CacheLoaderException {
        if (trace) {
            log.trace((Object)"remove(\"{0}\") ", new Object[]{key});
        }
        Cassandra.Iface cassandraClient = null;
        try {
            cassandraClient = this.pool.getConnection();
            HashMap<String, Map<String, List<Mutation>>> mutationMap = new HashMap<String, Map<String, List<Mutation>>>();
            this.remove0(CassandraCacheStore.hashKey(key), mutationMap);
            cassandraClient.batch_mutate(this.config.keySpace, mutationMap, ConsistencyLevel.ONE);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)("Exception while removing " + key), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.release(cassandraClient);
        }
    }

    private void remove0(String key, Map<String, Map<String, List<Mutation>>> mutationMap) {
        CassandraCacheStore.addMutation(mutationMap, key, this.config.entryColumnFamily, null, null);
    }

    private byte[] marshall(InternalCacheEntry entry) throws IOException, InterruptedException {
        return this.getMarshaller().objectToByteBuffer((Object)entry.toInternalCacheValue());
    }

    private InternalCacheEntry unmarshall(Object o, Object key) throws IOException, ClassNotFoundException {
        if (o == null) {
            return null;
        }
        byte[] b = (byte[])o;
        InternalCacheValue v = (InternalCacheValue)this.getMarshaller().objectFromByteBuffer(b);
        return v.toInternalCacheEntry(key);
    }

    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        Cassandra.Iface cassandraClient = null;
        try {
            cassandraClient = this.pool.getConnection();
            HashMap<String, Map<String, List<Mutation>>> mutationMap = new HashMap<String, Map<String, List<Mutation>>>(2);
            this.store0(entry, mutationMap);
            cassandraClient.batch_mutate(this.config.keySpace, mutationMap, ConsistencyLevel.ONE);
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.pool.release(cassandraClient);
        }
    }

    private void store0(InternalCacheEntry entry, Map<String, Map<String, List<Mutation>>> mutationMap) throws IOException {
        Object key = entry.getKey();
        if (trace) {
            log.trace((Object)"store(\"{0}\") ", new Object[]{key});
        }
        String cassandraKey = CassandraCacheStore.hashKey(key);
        try {
            CassandraCacheStore.addMutation(mutationMap, cassandraKey, this.config.entryColumnFamily, this.entryColumnPath.getColumn(), this.marshall(entry));
            if (entry.canExpire()) {
                this.addExpiryEntry(cassandraKey, entry.getExpiryTime(), mutationMap);
            }
        }
        catch (InterruptedException ie) {
            if (trace) {
                log.trace((Object)"Interrupted while trying to marshall entry");
            }
            Thread.currentThread().interrupt();
        }
    }

    private void addExpiryEntry(String cassandraKey, long expiryTime, Map<String, Map<String, List<Mutation>>> mutationMap) {
        try {
            CassandraCacheStore.addMutation(mutationMap, EXPIRATION_KEY, this.config.expirationColumnFamily, CassandraCacheStore.longToBytes(expiryTime), cassandraKey.getBytes("UTF-8"), emptyByteArray);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void toStream(ObjectOutput out) throws CacheLoaderException {
        try {
            Set<InternalCacheEntry> loadAll = this.loadAll();
            int count = 0;
            for (InternalCacheEntry entry : loadAll) {
                this.getMarshaller().objectToObjectStream((Object)entry, out);
                ++count;
            }
            this.getMarshaller().objectToObjectStream(null, out);
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    public void fromStream(ObjectInput in) throws CacheLoaderException {
        try {
            int count = 0;
            while (true) {
                ++count;
                InternalCacheEntry entry = (InternalCacheEntry)this.getMarshaller().objectFromObjectStream(in);
                if (entry != null) {
                    this.store(entry);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (InterruptedException ie) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Interrupted while reading from stream");
            }
            Thread.currentThread().interrupt();
        }
    }

    protected void purgeInternal() throws CacheLoaderException {
        if (trace) {
            log.trace((Object)"purgeInternal");
        }
        Cassandra.Iface cassandraClient = null;
        try {
            cassandraClient = this.pool.getConnection();
            SlicePredicate predicate = new SlicePredicate();
            predicate.setSlice_range(new SliceRange(emptyByteArray, CassandraCacheStore.longToBytes(System.currentTimeMillis()), false, 100));
            HashMap<String, Map<String, List<Mutation>>> mutationMap = new HashMap<String, Map<String, List<Mutation>>>();
            boolean complete = false;
            while (!complete) {
                List slice = cassandraClient.get_slice(this.config.keySpace, EXPIRATION_KEY, this.expirationColumnParent, predicate, ConsistencyLevel.ONE);
                complete = slice.size() < 100;
                for (ColumnOrSuperColumn crumb : slice) {
                    SuperColumn scol = crumb.getSuper_column();
                    Iterator i = scol.getColumnsIterator();
                    while (i.hasNext()) {
                        Column col = (Column)i.next();
                        this.remove0(new String(col.getName(), "UTF-8"), mutationMap);
                    }
                    CassandraCacheStore.addMutation(mutationMap, EXPIRATION_KEY, this.config.expirationColumnFamily, scol.getName(), null, null);
                }
            }
            cassandraClient.batch_mutate(this.config.keySpace, mutationMap, ConsistencyLevel.ONE);
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.pool.release(cassandraClient);
        }
    }

    protected void applyModifications(List<? extends Modification> mods) throws CacheLoaderException {
        Cassandra.Iface cassandraClient = null;
        try {
            cassandraClient = this.pool.getConnection();
            HashMap<String, Map<String, List<Mutation>>> mutationMap = new HashMap<String, Map<String, List<Mutation>>>();
            block10: for (Modification modification : mods) {
                switch (modification.getType()) {
                    case STORE: {
                        this.store0(((Store)modification).getStoredEntry(), mutationMap);
                        continue block10;
                    }
                    case CLEAR: {
                        this.clear();
                        continue block10;
                    }
                    case REMOVE: {
                        this.remove0(CassandraCacheStore.hashKey(((Remove)modification).getKey()), mutationMap);
                        continue block10;
                    }
                }
                throw new AssertionError();
            }
            cassandraClient.batch_mutate(this.config.keySpace, mutationMap, ConsistencyLevel.ONE);
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.pool.release(cassandraClient);
        }
    }

    public String toString() {
        return "CassandraCacheStore";
    }

    private static String hashKey(Object key) {
        return ENTRY_KEY_PREFIX + key.toString();
    }

    private static String unhashKey(String key) {
        if (key.startsWith(ENTRY_KEY_PREFIX)) {
            return key.substring(ENTRY_KEY_PREFIX.length());
        }
        return null;
    }

    private static void addMutation(Map<String, Map<String, List<Mutation>>> mutationMap, String key, String columnFamily, byte[] column, byte[] value) {
        CassandraCacheStore.addMutation(mutationMap, key, columnFamily, null, column, value);
    }

    private static void addMutation(Map<String, Map<String, List<Mutation>>> mutationMap, String key, String columnFamily, byte[] superColumn, byte[] column, byte[] value) {
        List<Mutation> columnFamilyMutations;
        Map<String, List<Mutation>> keyMutations = mutationMap.get(key);
        if (keyMutations == null) {
            keyMutations = new HashMap<String, List<Mutation>>();
            mutationMap.put(key, keyMutations);
        }
        if ((columnFamilyMutations = keyMutations.get(columnFamily)) == null) {
            columnFamilyMutations = new ArrayList<Mutation>();
            keyMutations.put(columnFamily, columnFamilyMutations);
        }
        if (value == null) {
            Deletion deletion = new Deletion(System.currentTimeMillis());
            if (superColumn != null) {
                deletion.setSuper_column(superColumn);
            }
            if (column != null) {
                deletion.setPredicate(new SlicePredicate().setColumn_names(Arrays.asList(new byte[][]{column})));
            }
            columnFamilyMutations.add(new Mutation().setDeletion(deletion));
        } else {
            ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
            if (superColumn != null) {
                ArrayList<Column> columns = new ArrayList<Column>();
                columns.add(new Column(column, value, System.currentTimeMillis()));
                cosc.setSuper_column(new SuperColumn(superColumn, columns));
            } else {
                cosc.setColumn(new Column(column, value, System.currentTimeMillis()));
            }
            columnFamilyMutations.add(new Mutation().setColumn_or_supercolumn(cosc));
        }
    }

    private static final byte[] longToBytes(long v) {
        byte[] b = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return b;
    }
}

