/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.FileUtils;
import org.infinispan.test.TestingUtil;

public class CassandraServiceDataCleaner {
    public void prepare() throws IOException {
        this.makeDirsIfNotExist();
        this.cleanupDataDirectories();
    }

    public void cleanupDataDirectories() throws IOException {
        for (String s : this.getDataDirs()) {
            TestingUtil.recursiveFileRemove((String)s);
        }
    }

    public void makeDirsIfNotExist() throws IOException {
        for (String s : this.getDataDirs()) {
            this.mkdir(s);
        }
    }

    private Set<String> getDataDirs() {
        HashSet<String> dirs = new HashSet<String>();
        for (String s : DatabaseDescriptor.getAllDataFileLocations()) {
            dirs.add(s);
        }
        dirs.add(DatabaseDescriptor.getLogFileLocation());
        return dirs;
    }

    private void mkdir(String dir) throws IOException {
        FileUtils.createDirectory((String)dir);
    }
}

