/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dataforte.cassandra.pool.DataSource;
import net.dataforte.cassandra.pool.PoolConfiguration;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.infinispan.Cache;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.cassandra.CassandraCacheStoreConfig;
import org.infinispan.loaders.cassandra.logging.Log;
import org.infinispan.loaders.keymappers.TwoWayKey2StringMapper;
import org.infinispan.loaders.keymappers.UnsupportedKeyTypeException;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.Util;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=CassandraCacheStoreConfig.class)
public class CassandraCacheStore
extends AbstractCacheStore {
    private static final String ENTRY_KEY_PREFIX = "entry_";
    private static final String ENTRY_COLUMN_NAME = "entry";
    private static final String EXPIRATION_KEY = "expiration";
    private static final int SLICE_SIZE = 100;
    private static final Log log = (Log)LogFactory.getLog(CassandraCacheStore.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private CassandraCacheStoreConfig config;
    private DataSource dataSource;
    private ConsistencyLevel readConsistencyLevel;
    private ConsistencyLevel writeConsistencyLevel;
    private String cacheName;
    private ColumnPath entryColumnPath;
    private ColumnParent entryColumnParent;
    private ColumnParent expirationColumnParent;
    private String entryKeyPrefix;
    private ByteBuffer expirationKey;
    private TwoWayKey2StringMapper keyMapper;
    private static Charset UTF8Charset = Charset.forName("UTF-8");

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return CassandraCacheStoreConfig.class;
    }

    public void init(CacheLoaderConfig clc, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(clc, cache, m);
        this.cacheName = cache.getName();
        this.config = (CassandraCacheStoreConfig)clc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws CacheLoaderException {
        try {
            if (!this.config.autoCreateKeyspace) {
                this.config.poolProperties.setKeySpace(this.config.keySpace);
            }
            this.dataSource = new DataSource((PoolConfiguration)this.config.getPoolProperties());
            this.readConsistencyLevel = ConsistencyLevel.valueOf((String)this.config.readConsistencyLevel);
            this.writeConsistencyLevel = ConsistencyLevel.valueOf((String)this.config.writeConsistencyLevel);
            this.entryColumnPath = new ColumnPath(this.config.entryColumnFamily).setColumn(ENTRY_COLUMN_NAME.getBytes(UTF8Charset));
            this.entryColumnParent = new ColumnParent(this.config.entryColumnFamily);
            this.entryKeyPrefix = ENTRY_KEY_PREFIX + (this.config.isSharedKeyspace() ? this.cacheName + "_" : "");
            this.expirationColumnParent = new ColumnParent(this.config.expirationColumnFamily);
            this.expirationKey = ByteBufferUtil.bytes((String)(EXPIRATION_KEY + (this.config.isSharedKeyspace() ? "_" + this.cacheName : "")));
            this.keyMapper = (TwoWayKey2StringMapper)Util.getInstance((String)this.config.getKeyMapper(), (ClassLoader)this.config.getClassLoader());
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        if (this.config.autoCreateKeyspace) {
            log.debug("automatically create keyspace");
            try {
                this.createKeySpace();
            }
            finally {
                this.dataSource.close();
            }
            this.dataSource.setKeySpace(this.config.keySpace);
        }
        log.debug("cleaning up expired entries...");
        this.purgeInternal();
        log.debug("started");
        super.start();
    }

    private void createKeySpace() throws CacheLoaderException {
        Cassandra.Client cassandraClient = null;
        try {
            cassandraClient = this.dataSource.getConnection();
            try {
                cassandraClient.describe_keyspace(this.config.keySpace);
                return;
            }
            catch (NotFoundException e) {
                try {
                    KsDef keySpace = new KsDef();
                    keySpace.setName(this.config.keySpace);
                    keySpace.setStrategy_class("org.apache.cassandra.locator.SimpleStrategy");
                    HashMap<String, String> strategy_options = new HashMap<String, String>();
                    strategy_options.put("replication_factor", "1");
                    keySpace.setStrategy_options(strategy_options);
                    CfDef entryCF = new CfDef();
                    entryCF.setName(this.config.entryColumnFamily);
                    entryCF.setKeyspace(this.config.keySpace);
                    entryCF.setComparator_type("BytesType");
                    keySpace.addToCf_defs(entryCF);
                    CfDef expirationCF = new CfDef();
                    expirationCF.setName(this.config.expirationColumnFamily);
                    expirationCF.setKeyspace(this.config.keySpace);
                    expirationCF.setColumn_type("Super");
                    expirationCF.setComparator_type("LongType");
                    expirationCF.setSubcomparator_type("BytesType");
                    keySpace.addToCf_defs(expirationCF);
                    cassandraClient.system_add_keyspace(keySpace);
                }
                catch (Exception e2) {
                    throw new CacheLoaderException("Could not create keyspace/column families", (Throwable)e2);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                this.dataSource.releaseConnection(cassandraClient);
            }
        }
        finally {
            this.dataSource.releaseConnection(cassandraClient);
        }
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        String hashKey = this.hashKey(key);
        Cassandra.Client cassandraClient = null;
        try {
            cassandraClient = this.dataSource.getConnection();
            ColumnOrSuperColumn column = cassandraClient.get(ByteBufferUtil.bytes((String)hashKey), this.entryColumnPath, this.readConsistencyLevel);
            InternalCacheEntry ice = this.unmarshall(column.getColumn().getValue(), key);
            if (ice != null && ice.isExpired()) {
                this.remove(key);
                InternalCacheEntry internalCacheEntry = null;
                return internalCacheEntry;
            }
            InternalCacheEntry internalCacheEntry = ice;
            return internalCacheEntry;
        }
        catch (NotFoundException nfe) {
            log.debugf("Key '%s' not found", hashKey);
            InternalCacheEntry internalCacheEntry = null;
            return internalCacheEntry;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.dataSource.releaseConnection(cassandraClient);
        }
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return this.load(Integer.MAX_VALUE);
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        Cassandra.Client cassandraClient = null;
        try {
            cassandraClient = this.dataSource.getConnection();
            HashSet<InternalCacheEntry> s = new HashSet<InternalCacheEntry>();
            SlicePredicate slicePredicate = new SlicePredicate();
            slicePredicate.setSlice_range(new SliceRange(ByteBuffer.wrap(this.entryColumnPath.getColumn()), ByteBufferUtil.EMPTY_BYTE_BUFFER, false, 1));
            String startKey = "";
            int sliceSize = Math.min(100, numEntries);
            boolean complete = false;
            while (!complete) {
                KeyRange keyRange = new KeyRange(sliceSize);
                keyRange.setStart_token(startKey);
                keyRange.setEnd_token("");
                List keySlices = cassandraClient.get_range_slices(this.entryColumnParent, slicePredicate, keyRange, this.readConsistencyLevel);
                for (KeySlice keySlice : keySlices) {
                    Object key = this.unhashKey(keySlice.getKey());
                    if (key == null) continue;
                    List columns = keySlice.getColumns();
                    if (columns.size() > 0) {
                        if (log.isDebugEnabled()) {
                            log.debugf("Loading %s", key);
                        }
                        byte[] value = ((ColumnOrSuperColumn)columns.get(0)).getColumn().getValue();
                        InternalCacheEntry ice = this.unmarshall(value, key);
                        s.add(ice);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debugf("Skipping empty key %s", key);
                }
                if (keySlices.size() < sliceSize) {
                    complete = true;
                    continue;
                }
                sliceSize = Math.min(100, numEntries - s.size());
                if (sliceSize == 0) {
                    complete = true;
                    continue;
                }
                startKey = new String(((KeySlice)keySlices.get(keySlices.size() - 1)).getKey(), UTF8Charset);
            }
            HashSet<InternalCacheEntry> hashSet = s;
            return hashSet;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.dataSource.releaseConnection(cassandraClient);
        }
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        Cassandra.Client cassandraClient = null;
        try {
            cassandraClient = this.dataSource.getConnection();
            HashSet<Object> s = new HashSet<Object>();
            SlicePredicate slicePredicate = new SlicePredicate();
            slicePredicate.setSlice_range(new SliceRange(ByteBuffer.wrap(this.entryColumnPath.getColumn()), ByteBufferUtil.EMPTY_BYTE_BUFFER, false, 1));
            String startKey = "";
            boolean complete = false;
            while (!complete) {
                KeyRange keyRange = new KeyRange(100);
                keyRange.setStart_token(startKey);
                keyRange.setEnd_token("");
                List keySlices = cassandraClient.get_range_slices(this.entryColumnParent, slicePredicate, keyRange, this.readConsistencyLevel);
                if (keySlices.size() < 100) {
                    complete = true;
                } else {
                    startKey = new String(((KeySlice)keySlices.get(keySlices.size() - 1)).getKey(), UTF8Charset);
                }
                for (KeySlice keySlice : keySlices) {
                    Object key;
                    if (keySlice.getColumnsSize() <= 0 || (key = this.unhashKey(keySlice.getKey())) == null || keysToExclude != null && keysToExclude.contains(key)) continue;
                    s.add(key);
                }
            }
            HashSet<Object> hashSet = s;
            return hashSet;
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.dataSource.releaseConnection(cassandraClient);
        }
    }

    public void stop() {
    }

    public void clear() throws CacheLoaderException {
        Cassandra.Client cassandraClient = null;
        try {
            cassandraClient = this.dataSource.getConnection();
            SlicePredicate slicePredicate = new SlicePredicate();
            slicePredicate.setSlice_range(new SliceRange(ByteBuffer.wrap(this.entryColumnPath.getColumn()), ByteBufferUtil.EMPTY_BYTE_BUFFER, false, 1));
            String startKey = "";
            boolean complete = false;
            while (!complete) {
                KeyRange keyRange = new KeyRange(100);
                keyRange.setStart_token(startKey);
                keyRange.setEnd_token("");
                List keySlices = cassandraClient.get_range_slices(this.entryColumnParent, slicePredicate, keyRange, this.readConsistencyLevel);
                if (keySlices.size() < 100) {
                    complete = true;
                } else {
                    startKey = new String(((KeySlice)keySlices.get(keySlices.size() - 1)).getKey(), UTF8Charset);
                }
                HashMap<ByteBuffer, Map<String, List<Mutation>>> mutationMap = new HashMap<ByteBuffer, Map<String, List<Mutation>>>();
                for (KeySlice keySlice : keySlices) {
                    this.remove0(ByteBuffer.wrap(keySlice.getKey()), mutationMap);
                }
                cassandraClient.batch_mutate(mutationMap, ConsistencyLevel.ALL);
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.dataSource.releaseConnection(cassandraClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key) throws CacheLoaderException {
        if (trace) {
            log.tracef("remove(\"%s\") ", key);
        }
        Cassandra.Client cassandraClient = null;
        try {
            cassandraClient = this.dataSource.getConnection();
            HashMap<ByteBuffer, Map<String, List<Mutation>>> mutationMap = new HashMap<ByteBuffer, Map<String, List<Mutation>>>();
            this.remove0(ByteBufferUtil.bytes((String)this.hashKey(key)), mutationMap);
            cassandraClient.batch_mutate(mutationMap, this.writeConsistencyLevel);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.errorRemovingKey(key, e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.dataSource.releaseConnection(cassandraClient);
        }
    }

    private void remove0(ByteBuffer key, Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap) {
        CassandraCacheStore.addMutation(mutationMap, key, this.config.entryColumnFamily, null, null);
    }

    private byte[] marshall(InternalCacheEntry entry) throws IOException, InterruptedException {
        return this.getMarshaller().objectToByteBuffer((Object)entry.toInternalCacheValue());
    }

    private InternalCacheEntry unmarshall(Object o, Object key) throws IOException, ClassNotFoundException {
        if (o == null) {
            return null;
        }
        byte[] b = (byte[])o;
        InternalCacheValue v = (InternalCacheValue)this.getMarshaller().objectFromByteBuffer(b);
        return v.toInternalCacheEntry(key);
    }

    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        Cassandra.Client cassandraClient = null;
        try {
            cassandraClient = this.dataSource.getConnection();
            HashMap<ByteBuffer, Map<String, List<Mutation>>> mutationMap = new HashMap<ByteBuffer, Map<String, List<Mutation>>>(2);
            this.store0(entry, mutationMap);
            cassandraClient.batch_mutate(mutationMap, this.writeConsistencyLevel);
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.dataSource.releaseConnection(cassandraClient);
        }
    }

    private void store0(InternalCacheEntry entry, Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap) throws IOException, UnsupportedKeyTypeException {
        Object key = entry.getKey();
        if (trace) {
            log.tracef("store(\"%s\") ", key);
        }
        String cassandraKey = this.hashKey(key);
        try {
            CassandraCacheStore.addMutation(mutationMap, ByteBufferUtil.bytes((String)cassandraKey), this.config.entryColumnFamily, ByteBuffer.wrap(this.entryColumnPath.getColumn()), ByteBuffer.wrap(this.marshall(entry)));
            if (entry.canExpire()) {
                this.addExpiryEntry(cassandraKey, entry.getExpiryTime(), mutationMap);
            }
        }
        catch (InterruptedException ie) {
            if (trace) {
                log.trace("Interrupted while trying to marshall entry");
            }
            Thread.currentThread().interrupt();
        }
    }

    private void addExpiryEntry(String cassandraKey, long expiryTime, Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap) {
        try {
            CassandraCacheStore.addMutation(mutationMap, this.expirationKey, this.config.expirationColumnFamily, ByteBufferUtil.bytes((long)expiryTime), ByteBufferUtil.bytes((String)cassandraKey), ByteBufferUtil.EMPTY_BYTE_BUFFER);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void toStream(ObjectOutput out) throws CacheLoaderException {
        try {
            Set<InternalCacheEntry> loadAll = this.loadAll();
            int count = 0;
            for (InternalCacheEntry entry : loadAll) {
                this.getMarshaller().objectToObjectStream((Object)entry, out);
                ++count;
            }
            this.getMarshaller().objectToObjectStream(null, out);
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    public void fromStream(ObjectInput in) throws CacheLoaderException {
        try {
            int count = 0;
            while (true) {
                ++count;
                InternalCacheEntry entry = (InternalCacheEntry)this.getMarshaller().objectFromObjectStream(in);
                if (entry != null) {
                    this.store(entry);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (InterruptedException ie) {
            if (log.isTraceEnabled()) {
                log.trace("Interrupted while reading from stream");
            }
            Thread.currentThread().interrupt();
        }
    }

    protected void purgeInternal() throws CacheLoaderException {
        if (trace) {
            log.trace("purgeInternal");
        }
        Cassandra.Client cassandraClient = null;
        try {
            cassandraClient = this.dataSource.getConnection();
            SlicePredicate predicate = new SlicePredicate();
            predicate.setSlice_range(new SliceRange(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.bytes((long)System.currentTimeMillis()), false, 100));
            HashMap<ByteBuffer, Map<String, List<Mutation>>> mutationMap = new HashMap<ByteBuffer, Map<String, List<Mutation>>>();
            boolean complete = false;
            while (!complete) {
                List slice = cassandraClient.get_slice(this.expirationKey, this.expirationColumnParent, predicate, this.readConsistencyLevel);
                complete = slice.size() < 100;
                for (ColumnOrSuperColumn crumb : slice) {
                    SuperColumn scol = crumb.getSuper_column();
                    Iterator i = scol.getColumnsIterator();
                    while (i.hasNext()) {
                        Column col = (Column)i.next();
                        this.remove0(ByteBuffer.wrap(col.getName()), mutationMap);
                    }
                    CassandraCacheStore.addMutation(mutationMap, this.expirationKey, this.config.expirationColumnFamily, ByteBuffer.wrap(scol.getName()), null, null);
                }
            }
            cassandraClient.batch_mutate(mutationMap, this.writeConsistencyLevel);
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.dataSource.releaseConnection(cassandraClient);
        }
    }

    protected void applyModifications(List<? extends Modification> mods) throws CacheLoaderException {
        Cassandra.Client cassandraClient = null;
        try {
            cassandraClient = this.dataSource.getConnection();
            HashMap<ByteBuffer, Map<String, List<Mutation>>> mutationMap = new HashMap<ByteBuffer, Map<String, List<Mutation>>>();
            block10: for (Modification modification : mods) {
                switch (modification.getType()) {
                    case STORE: {
                        this.store0(((Store)modification).getStoredEntry(), mutationMap);
                        continue block10;
                    }
                    case CLEAR: {
                        this.clear();
                        continue block10;
                    }
                    case REMOVE: {
                        this.remove0(ByteBufferUtil.bytes((String)this.hashKey(((Remove)modification).getKey())), mutationMap);
                        continue block10;
                    }
                }
                throw new AssertionError();
            }
            cassandraClient.batch_mutate(mutationMap, this.writeConsistencyLevel);
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            this.dataSource.releaseConnection(cassandraClient);
        }
    }

    public String toString() {
        return "CassandraCacheStore";
    }

    private String hashKey(Object key) throws UnsupportedKeyTypeException {
        if (!this.keyMapper.isSupportedType(key.getClass())) {
            throw new UnsupportedKeyTypeException(key);
        }
        return this.entryKeyPrefix + this.keyMapper.getStringMapping(key);
    }

    private Object unhashKey(byte[] key) {
        String skey = new String(key, UTF8Charset);
        if (skey.startsWith(this.entryKeyPrefix)) {
            return this.keyMapper.getKeyMapping(skey.substring(this.entryKeyPrefix.length()));
        }
        return null;
    }

    private static void addMutation(Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap, ByteBuffer key, String columnFamily, ByteBuffer column, ByteBuffer value) {
        CassandraCacheStore.addMutation(mutationMap, key, columnFamily, null, column, value);
    }

    private static void addMutation(Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap, ByteBuffer key, String columnFamily, ByteBuffer superColumn, ByteBuffer columnName, ByteBuffer value) {
        List<Mutation> columnFamilyMutations;
        Map<String, List<Mutation>> keyMutations = mutationMap.get(key);
        if (keyMutations == null) {
            keyMutations = new HashMap<String, List<Mutation>>();
            mutationMap.put(key, keyMutations);
        }
        if ((columnFamilyMutations = keyMutations.get(columnFamily)) == null) {
            columnFamilyMutations = new ArrayList<Mutation>();
            keyMutations.put(columnFamily, columnFamilyMutations);
        }
        if (value == null) {
            Deletion deletion = new Deletion();
            deletion.setTimestamp(CassandraCacheStore.microTimestamp());
            if (superColumn != null) {
                deletion.setSuper_column(superColumn);
            }
            if (columnName != null) {
                deletion.setPredicate(new SlicePredicate().setColumn_names(Collections.singletonList(columnName)));
            }
            columnFamilyMutations.add(new Mutation().setDeletion(deletion));
        } else {
            ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
            if (superColumn != null) {
                ArrayList<Column> columns = new ArrayList<Column>();
                Column col = new Column(columnName);
                col.setValue(value);
                col.setTimestamp(CassandraCacheStore.microTimestamp());
                columns.add(col);
                cosc.setSuper_column(new SuperColumn(superColumn, columns));
            } else {
                Column col = new Column(columnName);
                col.setValue(value);
                col.setTimestamp(CassandraCacheStore.microTimestamp());
                cosc.setColumn(col);
            }
            columnFamilyMutations.add(new Mutation().setColumn_or_supercolumn(cosc));
        }
    }

    private static long microTimestamp() {
        return System.currentTimeMillis() * 1000L;
    }
}

