/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra;

import java.io.IOException;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.thrift.transport.TTransportException;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.cassandra.CassandraCacheStore;
import org.infinispan.loaders.cassandra.CassandraCacheStoreConfig;
import org.infinispan.loaders.cassandra.EmbeddedServerHelper;
import org.infinispan.loaders.keymappers.UnsupportedKeyTypeException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.cassandra.CassandraCacheStoreTest")
public class CassandraCacheStoreTest
extends BaseCacheStoreTest {
    private static EmbeddedServerHelper embedded;

    @BeforeClass
    public static void setup() throws TTransportException, IOException, InterruptedException, ConfigurationException {
        embedded = new EmbeddedServerHelper();
        embedded.setup();
    }

    @AfterClass(alwaysRun=true)
    public static void cleanup() throws IOException {
        EmbeddedServerHelper.teardown();
        embedded = null;
    }

    protected CacheStore createCacheStore() throws Exception {
        CassandraCacheStore cs = new CassandraCacheStore();
        CassandraCacheStoreConfig clc = new CassandraCacheStoreConfig();
        clc.setHost("127.0.0.1");
        clc.setAutoCreateKeyspace(true);
        clc.setKeySpace("Infinispan");
        cs.init((CacheLoaderConfig)clc, this.getCache(), this.getMarshaller());
        cs.start();
        return cs;
    }

    @Test(expectedExceptions={UnsupportedKeyTypeException.class})
    public void testLoadAndStoreMarshalledValues() throws CacheLoaderException {
        super.testLoadAndStoreMarshalledValues();
    }
}

