/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.cassandra.configuration.CassandraCacheStoreConfiguration;
import org.infinispan.loaders.cassandra.configuration.CassandraCacheStoreConfigurationChildBuilder;
import org.infinispan.loaders.cassandra.configuration.CassandraServerConfiguration;
import org.infinispan.loaders.cassandra.configuration.CassandraServerConfigurationBuilder;
import org.infinispan.loaders.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.loaders.keymappers.Key2StringMapper;
import org.infinispan.util.TypedProperties;

public class CassandraCacheStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<CassandraCacheStoreConfiguration, CassandraCacheStoreConfigurationBuilder>
implements CassandraCacheStoreConfigurationChildBuilder {
    private boolean autoCreateKeyspace = true;
    private String configurationPropertiesFile;
    private String entryColumnFamily = "InfinispanEntries";
    private String expirationColumnFamily = "InfinispanExpiration";
    private boolean framed = true;
    private List<CassandraServerConfigurationBuilder> servers = new ArrayList<CassandraServerConfigurationBuilder>();
    private String keyMapper = DefaultTwoWayKey2StringMapper.class.getName();
    private String keySpace = "Infinispan";
    private String password;
    private ConsistencyLevel readConsistencyLevel = ConsistencyLevel.ONE;
    private boolean sharedKeyspace = false;
    private String username;
    private ConsistencyLevel writeConsistencyLevel = ConsistencyLevel.ONE;

    public CassandraCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public CassandraCacheStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public CassandraServerConfigurationBuilder addServer() {
        CassandraServerConfigurationBuilder server = new CassandraServerConfigurationBuilder(this);
        this.servers.add(server);
        return server;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder autoCreateKeyspace(boolean autoCreateKeyspace) {
        this.autoCreateKeyspace = autoCreateKeyspace;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder configurationPropertiesFile(String configurationPropertiesFile) {
        this.configurationPropertiesFile = configurationPropertiesFile;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder entryColumnFamily(String entryColumnFamily) {
        this.entryColumnFamily = entryColumnFamily;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder expirationColumnFamily(String expirationColumnFamily) {
        this.expirationColumnFamily = expirationColumnFamily;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder framed(boolean framed) {
        this.framed = framed;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder keyMapper(String keyMapper) {
        this.keyMapper = keyMapper;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder keyMapper(Class<? extends Key2StringMapper> keyMapper) {
        this.keyMapper = keyMapper.getName();
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder keySpace(String keySpace) {
        this.keySpace = keySpace;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder readConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public CassandraCacheStoreConfigurationBuilder writeConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
        return this;
    }

    public void validate() {
        super.validate();
        if (this.servers.isEmpty()) {
            throw new ConfigurationException("No servers specified");
        }
    }

    public CassandraCacheStoreConfiguration create() {
        ArrayList<CassandraServerConfiguration> remoteServers = new ArrayList<CassandraServerConfiguration>();
        for (CassandraServerConfigurationBuilder server : this.servers) {
            remoteServers.add(server.create());
        }
        return new CassandraCacheStoreConfiguration(this.autoCreateKeyspace, this.configurationPropertiesFile, this.entryColumnFamily, this.expirationColumnFamily, this.framed, remoteServers, this.keyMapper, this.keySpace, this.password, this.sharedKeyspace, this.username, this.readConsistencyLevel, this.writeConsistencyLevel, this.autoCreateKeyspace, this.sharedKeyspace, this.purgerThreads, this.framed, this.autoCreateKeyspace, TypedProperties.toTypedProperties((Properties)this.properties), this.async.create(), this.singletonStore.create());
    }

    public CassandraCacheStoreConfigurationBuilder read(CassandraCacheStoreConfiguration template) {
        this.autoCreateKeyspace = template.autoCreateKeyspace();
        this.configurationPropertiesFile = template.configurationPropertiesFile();
        this.entryColumnFamily = template.entryColumnFamily();
        this.expirationColumnFamily = template.expirationColumnFamily();
        this.framed = template.framed();
        for (CassandraServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.keyMapper = template.keyMapper();
        this.keySpace = template.keySpace();
        this.password = template.password();
        this.readConsistencyLevel = template.readConsistencyLevel();
        this.sharedKeyspace = template.sharedKeyspace();
        this.username = template.username();
        this.writeConsistencyLevel = template.writeConsistencyLevel();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }
}

