/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra.configuration;

import java.util.Collections;
import java.util.List;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.cassandra.CassandraCacheStoreConfig;
import org.infinispan.loaders.cassandra.configuration.CassandraCacheStoreConfigurationBuilder;
import org.infinispan.loaders.cassandra.configuration.CassandraServerConfiguration;
import org.infinispan.util.TypedProperties;

@BuiltBy(value=CassandraCacheStoreConfigurationBuilder.class)
public class CassandraCacheStoreConfiguration
extends AbstractStoreConfiguration
implements LegacyLoaderAdapter<CassandraCacheStoreConfig> {
    private final boolean autoCreateKeyspace;
    private final String configurationPropertiesFile;
    private final String entryColumnFamily;
    private final String expirationColumnFamily;
    private final boolean framed;
    private final List<CassandraServerConfiguration> servers;
    private final String keyMapper;
    private final String keySpace;
    private final String password;
    private final ConsistencyLevel readConsistencyLevel;
    private final boolean sharedKeyspace;
    private final String username;
    private final ConsistencyLevel writeConsistencyLevel;

    public CassandraCacheStoreConfiguration(boolean autoCreateKeyspace, String configurationPropertiesFile, String entryColumnFamily, String expirationColumnFamily, boolean framed, List<CassandraServerConfiguration> servers, String keyMapper, String keySpace, String password, boolean sharedKeyspace, String username, ConsistencyLevel readConsistencyLevel, ConsistencyLevel writeConsistencyLevel, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration asyncStoreConfiguration, SingletonStoreConfiguration singletonStoreConfiguration) {
        super(purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, asyncStoreConfiguration, singletonStoreConfiguration);
        this.autoCreateKeyspace = autoCreateKeyspace;
        this.configurationPropertiesFile = configurationPropertiesFile;
        this.entryColumnFamily = entryColumnFamily;
        this.expirationColumnFamily = expirationColumnFamily;
        this.framed = framed;
        this.servers = Collections.unmodifiableList(servers);
        this.keyMapper = keyMapper;
        this.keySpace = keySpace;
        this.password = password;
        this.sharedKeyspace = sharedKeyspace;
        this.username = username;
        this.readConsistencyLevel = readConsistencyLevel;
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    public boolean autoCreateKeyspace() {
        return this.autoCreateKeyspace;
    }

    public String configurationPropertiesFile() {
        return this.configurationPropertiesFile;
    }

    public String entryColumnFamily() {
        return this.entryColumnFamily;
    }

    public String expirationColumnFamily() {
        return this.expirationColumnFamily;
    }

    public boolean framed() {
        return this.framed;
    }

    public String keyMapper() {
        return this.keyMapper;
    }

    public List<CassandraServerConfiguration> hosts() {
        return this.servers;
    }

    public String keySpace() {
        return this.keySpace;
    }

    public List<CassandraServerConfiguration> servers() {
        return this.servers;
    }

    public boolean sharedKeyspace() {
        return this.sharedKeyspace;
    }

    public String password() {
        return this.password;
    }

    public String username() {
        return this.username;
    }

    public ConsistencyLevel readConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public ConsistencyLevel writeConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public CassandraCacheStoreConfig adapt() {
        CassandraCacheStoreConfig config = new CassandraCacheStoreConfig();
        LegacyConfigurationAdaptor.adapt((StoreConfiguration)this, (CacheStoreConfig)config);
        config.setAutoCreateKeyspace(this.autoCreateKeyspace);
        config.setConfigurationPropertiesFile(this.configurationPropertiesFile);
        config.setEntryColumnFamily(this.entryColumnFamily);
        config.setExpirationColumnFamily(this.expirationColumnFamily);
        config.setFramed(this.framed);
        StringBuilder host = new StringBuilder();
        for (CassandraServerConfiguration s : this.servers) {
            if (host.length() > 0) {
                host.append(";");
            }
            host.append(s.host());
        }
        config.setHost(host.toString());
        config.setKeyMapper(this.keyMapper);
        config.setKeySpace(this.keySpace);
        config.setPassword(this.password);
        config.setReadConsistencyLevel(this.readConsistencyLevel);
        config.setSharedKeyspace(this.sharedKeyspace);
        config.setUsername(this.username);
        config.setWriteConsistencyLevel(this.writeConsistencyLevel);
        return config;
    }
}

