/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    AUTO_CREATE_KEYSPACE("autoCreateKeyspace"),
    CONFIGURATION_PROPERTIES_FILE("configurationPropertiesFile"),
    ENTRY_COLUMN_FAMILY("entryColumnFamily"),
    EXPIRATION_COLUMN_FAMILY("expirationColumnFamily"),
    FRAMED("framed"),
    HOST("host"),
    KEY_MAPPER("keyMapper"),
    KEY_SPACE("keySpace"),
    PASSWORD("PASSWORD"),
    PORT("port"),
    USERNAME("USERNAME"),
    READ_CONSISTENCY_LEVEL("readConsistencyLevel"),
    WRITE_CONSISTENCY_LEVEL("writeConsistencyLevel");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

