/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.cassandra.configuration.CassandraCacheStoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.cassandra.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cacheManager;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testRemoteCacheStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.3 http://www.infinispan.org/schemas/infinispan-config-5.3.xsd\"\n      xmlns=\"urn:infinispan:config:5.3\">   <default>\n     <loaders>\n       <cassandraStore xmlns=\"urn:infinispan:config:cassandra:5.3\" autoCreateKeyspace=\"false\" fetchPersistentState=\"true\" readConsistencyLevel=\"EACH_QUORUM\" writeConsistencyLevel=\"ANY\">\n         <servers>\n           <server host=\"one\" />\n           <server host=\"two\" />\n         </servers>\n         <async enabled=\"true\" />\n       </cassandraStore>\n     </loaders>\n   </default>\n</infinispan>";
        CassandraCacheStoreConfiguration store = (CassandraCacheStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        assert (!store.autoCreateKeyspace());
        assert (store.framed());
        assert (store.servers().size() == 2);
        assert (store.readConsistencyLevel().equals((Object)ConsistencyLevel.EACH_QUORUM));
        assert (store.writeConsistencyLevel().equals((Object)ConsistencyLevel.ANY));
        assert (store.fetchPersistentState());
        assert (store.async().enabled());
    }

    private CacheLoaderConfiguration buildCacheManagerWithCacheStore(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        assert (this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().size() == 1);
        return (CacheLoaderConfiguration)this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().get(0);
    }
}

