/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.dataforte.cassandra.pool.PoolProperties;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.cassandra.CassandraCacheStore;
import org.infinispan.loaders.keymappers.DefaultTwoWayKey2StringMapper;

public class CassandraCacheStoreConfig
extends AbstractCacheStoreConfig {
    String keySpace = "Infinispan";
    String entryColumnFamily = "InfinispanEntries";
    String expirationColumnFamily = "InfinispanExpiration";
    boolean sharedKeyspace = false;
    String readConsistencyLevel = "ONE";
    String writeConsistencyLevel = "ONE";
    String configurationPropertiesFile;
    String keyMapper = DefaultTwoWayKey2StringMapper.class.getName();
    boolean autoCreateKeyspace = true;
    protected PoolProperties poolProperties;

    public CassandraCacheStoreConfig() {
        this.setCacheLoaderClassName(CassandraCacheStore.class.getName());
        this.poolProperties = new PoolProperties();
    }

    public String getKeySpace() {
        return this.keySpace;
    }

    public void setKeySpace(String keySpace) {
        this.keySpace = keySpace;
    }

    public String getEntryColumnFamily() {
        return this.entryColumnFamily;
    }

    public void setEntryColumnFamily(String entryColumnFamily) {
        this.entryColumnFamily = entryColumnFamily;
    }

    public String getExpirationColumnFamily() {
        return this.expirationColumnFamily;
    }

    public void setExpirationColumnFamily(String expirationColumnFamily) {
        this.expirationColumnFamily = expirationColumnFamily;
    }

    public boolean isSharedKeyspace() {
        return this.sharedKeyspace;
    }

    public void setSharedKeyspace(boolean sharedKeyspace) {
        this.sharedKeyspace = sharedKeyspace;
    }

    public String getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(String readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public String getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void setWriteConsistencyLevel(String writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    public PoolProperties getPoolProperties() {
        return this.poolProperties;
    }

    public void setHost(String host) {
        this.poolProperties.setHost(host);
    }

    public String getHost() {
        return this.poolProperties.getHost();
    }

    public void setPort(int port) {
        this.poolProperties.setPort(port);
    }

    public int getPort() {
        return this.poolProperties.getPort();
    }

    public boolean isFramed() {
        return this.poolProperties.isFramed();
    }

    public String getPassword() {
        return this.poolProperties.getPassword();
    }

    public String getUsername() {
        return this.poolProperties.getUsername();
    }

    public void setFramed(boolean framed) {
        this.poolProperties.setFramed(framed);
    }

    public void setPassword(String password) {
        this.poolProperties.setPassword(password);
    }

    public void setUsername(String username) {
        this.poolProperties.setUsername(username);
    }

    public void setDatasourceJndiLocation(String location) {
        this.poolProperties.setDataSourceJNDI(location);
    }

    public String getDatasourceJndiLocation() {
        return this.poolProperties.getDataSourceJNDI();
    }

    public String getConfigurationPropertiesFile() {
        return this.configurationPropertiesFile;
    }

    public void setConfigurationPropertiesFile(String configurationPropertiesFile) {
        this.configurationPropertiesFile = configurationPropertiesFile;
        this.readConfigurationProperties();
    }

    private void readConfigurationProperties() {
        if (this.configurationPropertiesFile == null || this.configurationPropertiesFile.trim().length() == 0) {
            return;
        }
        InputStream i = FileLookupFactory.newInstance().lookupFile(this.configurationPropertiesFile, this.getClassLoader());
        if (i != null) {
            Properties p = new Properties();
            try {
                p.load(i);
            }
            catch (IOException ioe) {
                throw new CacheConfigurationException("Unable to read environment properties file " + this.configurationPropertiesFile, (Throwable)ioe);
            }
            finally {
                Util.close((Closeable)i);
            }
            for (String propertyName : p.stringPropertyNames()) {
                this.poolProperties.set(propertyName, (Object)p.getProperty(propertyName));
            }
        }
    }

    public String getKeyMapper() {
        return this.keyMapper;
    }

    public void setKeyMapper(String keyMapper) {
        this.keyMapper = keyMapper;
    }

    public boolean isAutoCreateKeyspace() {
        return this.autoCreateKeyspace;
    }

    public void setAutoCreateKeyspace(boolean autoCreateKeyspace) {
        this.autoCreateKeyspace = autoCreateKeyspace;
    }

    public void setReadConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel.toString();
    }

    public void setWriteConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel.toString();
    }
}

