/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser52;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.loaders.cassandra.configuration.Attribute;
import org.infinispan.loaders.cassandra.configuration.CassandraCacheStoreConfigurationBuilder;
import org.infinispan.loaders.cassandra.configuration.CassandraCacheStoreConfigurationChildBuilder;
import org.infinispan.loaders.cassandra.configuration.CassandraServerConfigurationBuilder;
import org.infinispan.loaders.cassandra.configuration.Element;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:cassandra:5.3", root="cassandraStore")})
public class CassandraCacheStoreConfigurationParser53
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case CASSANDRA_STORE: {
                this.parseCassandraStore(reader, builder.loaders(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseCassandraStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder, ClassLoader classLoader) throws XMLStreamException {
        CassandraCacheStoreConfigurationBuilder builder = new CassandraCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseCassandraStoreAttributes(reader, builder);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVERS: {
                    this.parseServers(reader, builder);
                    continue block3;
                }
            }
            Parser52.parseCommonStoreChildren((XMLExtendedStreamReader)reader, (CacheStoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseServers(XMLExtendedStreamReader reader, CassandraCacheStoreConfigurationChildBuilder builder) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVER: {
                    this.parseServer(reader, builder.addServer());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseServer(XMLExtendedStreamReader reader, CassandraServerConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    builder.host(value);
                    continue block4;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseCassandraStoreAttributes(XMLExtendedStreamReader reader, CassandraCacheStoreConfigurationBuilder builder) throws XMLStreamException {
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTO_CREATE_KEYSPACE: {
                    builder.autoCreateKeyspace(Boolean.parseBoolean(value));
                    continue block13;
                }
                case CONFIGURATION_PROPERTIES_FILE: {
                    builder.configurationPropertiesFile(value);
                    continue block13;
                }
                case ENTRY_COLUMN_FAMILY: {
                    builder.entryColumnFamily(value);
                    continue block13;
                }
                case EXPIRATION_COLUMN_FAMILY: {
                    builder.expirationColumnFamily(value);
                    continue block13;
                }
                case FRAMED: {
                    builder.framed(true);
                    continue block13;
                }
                case KEY_MAPPER: {
                    builder.keyMapper(value);
                    continue block13;
                }
                case KEY_SPACE: {
                    builder.keySpace(value);
                    continue block13;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block13;
                }
                case READ_CONSISTENCY_LEVEL: {
                    builder.readConsistencyLevel(ConsistencyLevel.valueOf((String)value));
                    continue block13;
                }
                case USERNAME: {
                    builder.username(value);
                    continue block13;
                }
                case WRITE_CONSISTENCY_LEVEL: {
                    builder.writeConsistencyLevel(ConsistencyLevel.valueOf((String)value));
                    continue block13;
                }
                default: {
                    Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
    }
}

