/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cassandra.configuration;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.loaders.cassandra.configuration.AbstractCassandraCacheStoreConfigurationChildBuilder;
import org.infinispan.loaders.cassandra.configuration.CassandraCacheStoreConfigurationBuilder;
import org.infinispan.loaders.cassandra.configuration.CassandraServerConfiguration;

public class CassandraServerConfigurationBuilder
extends AbstractCassandraCacheStoreConfigurationChildBuilder<CassandraCacheStoreConfigurationBuilder>
implements Builder<CassandraServerConfiguration> {
    private String host;
    private int port = 9160;

    protected CassandraServerConfigurationBuilder(CassandraCacheStoreConfigurationBuilder builder) {
        super(builder);
    }

    public CassandraServerConfigurationBuilder host(String host) {
        this.host = host;
        return this;
    }

    public CassandraServerConfigurationBuilder port(int port) {
        this.port = port;
        return this;
    }

    public void validate() {
        if (this.host == null) {
            throw new CacheConfigurationException("Missing host");
        }
    }

    public CassandraServerConfiguration create() {
        return new CassandraServerConfiguration(this.host, this.port);
    }

    public CassandraServerConfigurationBuilder read(CassandraServerConfiguration template) {
        this.host = template.host();
        this.port = template.port();
        return this;
    }
}

