/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cassandra;

import java.io.IOException;
import org.apache.cassandra.service.EmbeddedCassandraService;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.cassandra.CassandraStore;
import org.infinispan.persistence.cassandra.SingleEmbeddedCassandraService;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledTimeService;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="CassandraStoreTest", groups={"functional"})
public class CassandraStoreTest
extends BaseStoreTest {
    @BeforeClass
    public static void setup() throws PersistenceException, IOException {
        SingleEmbeddedCassandraService.start();
    }

    protected CassandraStoreConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder lcb) {
        CassandraStoreConfigurationBuilder cfg = ((CassandraStoreConfigurationBuilder)lcb.addStore(CassandraStoreConfigurationBuilder.class)).entryTable(((Object)((Object)this)).getClass().getSimpleName());
        cfg.autoCreateKeyspace(true);
        cfg.addServer().host("localhost");
        return cfg;
    }

    protected ControlledTimeService getTimeService() {
        return new ControlledTimeService(0L){

            public void advance(long time) {
                this.currentMillis += time;
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected AdvancedLoadWriteStore createStore() throws Exception {
        EmbeddedCassandraService ecs = new EmbeddedCassandraService();
        CassandraStore ccs = new CassandraStore();
        ConfigurationBuilder cb = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        this.createCacheStoreConfig(cb.persistence());
        ccs.init(this.createContext(cb.build()));
        return ccs;
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }
}

