/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cassandra.configuration;

import com.datastax.driver.core.ConsistencyLevel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser80;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.cassandra.configuration.Attribute;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConfigurationBuilder;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreServerConfigurationBuilder;
import org.infinispan.persistence.cassandra.configuration.Element;

@Namespaces(value={@Namespace(uri="urn:infinispan:config:store:cassandra:8.2", root="cassandra-store"), @Namespace(root="cassandra-store")})
public class CassandraStoreConfigurationParser82
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case CASSANDRA_STORE: {
                this.parseCassandraStore(reader, builder.persistence());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseCassandraStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder persistenceBuilder) throws XMLStreamException {
        CassandraStoreConfigurationBuilder builder = new CassandraStoreConfigurationBuilder(persistenceBuilder);
        this.parseCassAttributes(reader, builder);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_POOL: {
                    this.parseConnectionPool(reader, builder.connectionPool());
                    continue block4;
                }
                case CASSANDRA_SERVER: {
                    this.parseServer(reader, builder.addServer());
                    continue block4;
                }
            }
            Parser80.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        persistenceBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseConnectionPool(XMLExtendedStreamReader reader, CassandraStoreConnectionPoolConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case POOL_TIMEOUT_MILLIS: {
                    builder.poolTimeoutMillis(Integer.parseInt(value));
                    continue block5;
                }
                case HEARTBEAT_INTERVAL_SECONDS: {
                    builder.heartbeatIntervalSeconds(Integer.parseInt(value));
                    continue block5;
                }
                case IDLE_TIMEOUT_SECONDS: {
                    builder.idleTimeoutSeconds(Integer.parseInt(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseServer(XMLExtendedStreamReader reader, CassandraStoreServerConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    builder.host(value);
                    continue block4;
                }
                case PORT: {
                    builder.port(Integer.parseInt(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseCassAttributes(XMLExtendedStreamReader reader, CassandraStoreConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case AUTO_CREATE_KEYSPACE: {
                    builder.autoCreateKeyspace(Boolean.parseBoolean(value));
                    continue block7;
                }
                case KEYSPACE: {
                    builder.keyspace(value);
                    continue block7;
                }
                case ENTRY_TABLE: {
                    builder.entryTable(value);
                    continue block7;
                }
                case CONSISTENCY_LEVEL: {
                    builder.consistencyLevel(ConsistencyLevel.valueOf((String)value));
                    continue block7;
                }
                case SERIAL_CONSISTENCY_LEVEL: {
                    builder.serialConsistencyLevel(ConsistencyLevel.valueOf((String)value));
                    continue block7;
                }
                default: {
                    Parser80.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

