/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cassandra.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    AUTO_CREATE_KEYSPACE("auto-create-keyspace"),
    KEYSPACE("keyspace"),
    ENTRY_TABLE("entry-table"),
    CONSISTENCY_LEVEL("consistency-level"),
    SERIAL_CONSISTENCY_LEVEL("serial-consistency-level"),
    HOST("host"),
    PORT("port"),
    POOL_TIMEOUT_MILLIS("pool-timeout-millis"),
    HEARTBEAT_INTERVAL_SECONDS("heartbeat-interval-seconds"),
    IDLE_TIMEOUT_SECONDS("idle-timeout-seconds");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

