/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cassandra.configuration;

import com.datastax.driver.core.ConsistencyLevel;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.persistence.cassandra.CassandraStore;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConfigurationBuilder;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConnectionPoolConfiguration;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreServerConfiguration;

@ConfigurationFor(value=CassandraStore.class)
@BuiltBy(value=CassandraStoreConfigurationBuilder.class)
public class CassandraStoreConfiguration
extends AbstractStoreConfiguration {
    static final AttributeDefinition<Boolean> AUTO_CREATE_KEYSPACE = AttributeDefinition.builder((String)"autoCreateKeyspace", (Object)true).immutable().build();
    static final AttributeDefinition<String> KEYSPACE = AttributeDefinition.builder((String)"keyspace", (Object)"Infinispan").immutable().build();
    static final AttributeDefinition<String> ENTRY_TABLE = AttributeDefinition.builder((String)"entryTable", (Object)"InfinispanEntries").immutable().build();
    static final AttributeDefinition<ConsistencyLevel> CONSISTENCY_LEVEL = AttributeDefinition.builder((String)"consistencyLevel", (Object)ConsistencyLevel.LOCAL_ONE).immutable().build();
    static final AttributeDefinition<ConsistencyLevel> SERIAL_CONSISTENCY_LEVEL = AttributeDefinition.builder((String)"serialConsistencyLevel", (Object)ConsistencyLevel.SERIAL).immutable().build();
    static final AttributeDefinition<List<CassandraStoreServerConfiguration>> SERVERS = AttributeDefinition.builder((String)"servers", null, List.class).initializer(ArrayList::new).build();
    private final Attribute<Boolean> autoCreateKeyspace;
    private final Attribute<String> entryTable;
    private final Attribute<String> keyspace;
    private final Attribute<ConsistencyLevel> consistencyLevel;
    private final Attribute<ConsistencyLevel> serialConsistencyLevel;
    private final Attribute<List<CassandraStoreServerConfiguration>> servers;
    private final CassandraStoreConnectionPoolConfiguration connectionPool;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(CassandraStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{AUTO_CREATE_KEYSPACE, ENTRY_TABLE, KEYSPACE, CONSISTENCY_LEVEL, SERIAL_CONSISTENCY_LEVEL, SERVERS});
    }

    public CassandraStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, CassandraStoreConnectionPoolConfiguration connectionPool) {
        super(attributes, async, singletonStore);
        this.autoCreateKeyspace = attributes.attribute(AUTO_CREATE_KEYSPACE);
        this.entryTable = attributes.attribute(ENTRY_TABLE);
        this.keyspace = attributes.attribute(KEYSPACE);
        this.consistencyLevel = attributes.attribute(CONSISTENCY_LEVEL);
        this.serialConsistencyLevel = attributes.attribute(SERIAL_CONSISTENCY_LEVEL);
        this.servers = attributes.attribute(SERVERS);
        this.connectionPool = connectionPool;
    }

    public Boolean autoCreateKeyspace() {
        return (Boolean)this.autoCreateKeyspace.get();
    }

    public String entryTable() {
        return (String)this.entryTable.get();
    }

    public String keyspace() {
        return (String)this.keyspace.get();
    }

    public ConsistencyLevel consistencyLevel() {
        return (ConsistencyLevel)this.consistencyLevel.get();
    }

    public ConsistencyLevel serialCconsistencyLevel() {
        return (ConsistencyLevel)this.serialConsistencyLevel.get();
    }

    public List<CassandraStoreServerConfiguration> servers() {
        return (List)this.servers.get();
    }

    public CassandraStoreConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }
}

