/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cassandra.configuration;

import com.datastax.driver.core.ConsistencyLevel;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConfiguration;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConfigurationChildBuilder;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConnectionPoolConfigurationBuilder;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreServerConfiguration;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreServerConfigurationBuilder;

public class CassandraStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<CassandraStoreConfiguration, CassandraStoreConfigurationBuilder>
implements CassandraStoreConfigurationChildBuilder<CassandraStoreConfigurationBuilder> {
    private final CassandraStoreConnectionPoolConfigurationBuilder connectionPool;
    private List<CassandraStoreServerConfigurationBuilder> servers = new ArrayList<CassandraStoreServerConfigurationBuilder>();

    public CassandraStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, CassandraStoreConfiguration.attributeDefinitionSet());
        this.connectionPool = new CassandraStoreConnectionPoolConfigurationBuilder(this);
    }

    public CassandraStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public CassandraStoreConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public CassandraStoreConfigurationBuilder autoCreateKeyspace(boolean autoCreateKeyspace) {
        this.attributes.attribute(CassandraStoreConfiguration.AUTO_CREATE_KEYSPACE).set((Object)autoCreateKeyspace);
        return this;
    }

    @Override
    public CassandraStoreConfigurationBuilder entryTable(String entryTable) {
        this.attributes.attribute(CassandraStoreConfiguration.ENTRY_TABLE).set((Object)entryTable);
        return this;
    }

    @Override
    public CassandraStoreConfigurationBuilder keyspace(String keyspace) {
        this.attributes.attribute(CassandraStoreConfiguration.KEYSPACE).set((Object)keyspace);
        return this;
    }

    @Override
    public CassandraStoreConfigurationBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
        this.attributes.attribute(CassandraStoreConfiguration.CONSISTENCY_LEVEL).set((Object)consistencyLevel);
        return this;
    }

    @Override
    public CassandraStoreConfigurationBuilder serialConsistencyLevel(ConsistencyLevel serialConsistencyLevel) {
        this.attributes.attribute(CassandraStoreConfiguration.SERIAL_CONSISTENCY_LEVEL).set((Object)serialConsistencyLevel);
        return this;
    }

    @Override
    public CassandraStoreServerConfigurationBuilder addServer() {
        CassandraStoreServerConfigurationBuilder builder = new CassandraStoreServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    public CassandraStoreConfigurationBuilder addProperty(String key, String value) {
        switch (key) {
            case "autoCreateKeyspace": {
                return this.autoCreateKeyspace(Boolean.parseBoolean(value));
            }
            case "keyspace": {
                return this.keyspace(value);
            }
            case "entryTable": {
                return this.entryTable(value);
            }
            case "consistencyLevel": {
                return this.consistencyLevel(ConsistencyLevel.valueOf((String)value));
            }
            case "serialConsistencyLevel": {
                return this.serialConsistencyLevel(ConsistencyLevel.valueOf((String)value));
            }
            case "servers": {
                String[] split;
                for (String s : split = value.split(",")) {
                    String host = s.substring(0, s.indexOf(91));
                    this.addServer().host(host).port(Integer.parseInt(s.substring(s.indexOf(91) + 1, s.indexOf(93))));
                }
                return this;
            }
            case "connectionPool.heartbeatIntervalSeconds": {
                this.connectionPool().heartbeatIntervalSeconds(Integer.parseInt(value));
                return this;
            }
            case "connectionPool.idleTimeoutSeconds": {
                this.connectionPool().idleTimeoutSeconds(Integer.parseInt(value));
                return this;
            }
            case "connectionPool.poolTimeoutMillis": {
                this.connectionPool().poolTimeoutMillis(Integer.parseInt(value));
                return this;
            }
        }
        throw new CacheConfigurationException("Couldn't find a configuration option named [" + key + "] in CassandraStore!");
    }

    public CassandraStoreConfiguration create() {
        ArrayList<CassandraStoreServerConfiguration> cassServers = new ArrayList<CassandraStoreServerConfiguration>();
        for (CassandraStoreServerConfigurationBuilder server : this.servers) {
            cassServers.add(server.create());
        }
        this.attributes.attribute(CassandraStoreConfiguration.SERVERS).set(cassServers);
        return new CassandraStoreConfiguration(this.attributes.protect(), this.async.create(), this.singletonStore.create(), this.connectionPool.create());
    }

    public CassandraStoreConfigurationBuilder read(CassandraStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        this.connectionPool.read(template.connectionPool());
        for (CassandraStoreServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        return this;
    }

    public void validate() {
        this.connectionPool.validate();
        for (CassandraStoreServerConfigurationBuilder server : this.servers) {
            server.validate();
        }
    }
}

