/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cassandra.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.cassandra.configuration.AbstractCassandraStoreConfigurationChildBuilder;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConfigurationBuilder;
import org.infinispan.persistence.cassandra.configuration.CassandraStoreConnectionPoolConfiguration;

public class CassandraStoreConnectionPoolConfigurationBuilder
extends AbstractCassandraStoreConfigurationChildBuilder<CassandraStoreConfigurationBuilder>
implements Builder<CassandraStoreConnectionPoolConfiguration> {
    private int poolTimeoutMillis = 5;
    private int heartbeatIntervalSeconds = 30;
    private int idleTimeoutSeconds = 120;

    CassandraStoreConnectionPoolConfigurationBuilder(CassandraStoreConfigurationBuilder builder) {
        super(builder);
    }

    public CassandraStoreConnectionPoolConfigurationBuilder poolTimeoutMillis(int poolTimeoutMillis) {
        this.poolTimeoutMillis = poolTimeoutMillis;
        return this;
    }

    public CassandraStoreConnectionPoolConfigurationBuilder heartbeatIntervalSeconds(int heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
        return this;
    }

    public CassandraStoreConnectionPoolConfigurationBuilder idleTimeoutSeconds(int idleTimeoutSeconds) {
        this.idleTimeoutSeconds = idleTimeoutSeconds;
        return this;
    }

    public void validate() {
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public CassandraStoreConnectionPoolConfiguration create() {
        return new CassandraStoreConnectionPoolConfiguration(this.poolTimeoutMillis, this.heartbeatIntervalSeconds, this.idleTimeoutSeconds);
    }

    public CassandraStoreConnectionPoolConfigurationBuilder read(CassandraStoreConnectionPoolConfiguration template) {
        this.poolTimeoutMillis = template.poolTimeoutMillis();
        this.heartbeatIntervalSeconds = template.heartbeatIntervalSeconds();
        this.idleTimeoutSeconds = template.idleTimeoutSeconds();
        return this;
    }
}

