/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;

public class EmbeddedServerHelper {
    public static int zooKeeperPort = -1;
    private static String zkBaseDir = System.getProperty("java.io.tmpdir") + "/embedded-zk";
    private static String hbaseRootDir = System.getProperty("java.io.tmpdir") + "/embedded-hbase-" + System.currentTimeMillis();
    static ExecutorService executor = Executors.newSingleThreadExecutor();

    public void setup() throws InterruptedException {
        executor.execute(new HBaseRunner());
        try {
            TimeUnit.SECONDS.sleep(3L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void teardown() throws IOException {
        executor.shutdown();
        executor.shutdownNow();
        FileUtils.deleteDirectory((File)new File(zkBaseDir));
        FileUtils.deleteDirectory((File)new File(hbaseRootDir));
    }

    class HBaseRunner
    implements Runnable {
        HBaseRunner() {
        }

        @Override
        public void run() {
            Configuration conf = HBaseConfiguration.create();
            try {
                MiniZooKeeperCluster zkCluster = new MiniZooKeeperCluster(conf);
                zooKeeperPort = zkCluster.startup(new File(zkBaseDir + "/" + String.valueOf(System.currentTimeMillis())));
                conf.set("hbase.zookeeper.property.clientPort", Integer.toString(zooKeeperPort));
                conf.set("hbase.rootdir", hbaseRootDir);
                conf.set("hbase.master.dns.interface", "lo");
                conf.set("hbase.regionserver.dns.interface", "lo");
                LocalHBaseCluster cluster = new LocalHBaseCluster(conf, 1, 1);
                cluster.startup();
            }
            catch (Exception ex) {
                System.err.println("Exception happened when running HBase: " + ex.getMessage());
            }
        }
    }
}

